/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.context;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.devtools.mobileharness.shared.constant.closeable.NonThrowingAutoCloseable;
import com.google.devtools.mobileharness.shared.context.AutoValue_InvocationContext_InvocationInfo;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class InvocationContext {
    private static final ThreadLocal<InvocationContext> CONTEXT = ThreadLocal.withInitial(InvocationContext::new);
    private final Map<InvocationType, InvocationInfo> context = new EnumMap<InvocationType, InvocationInfo>(InvocationType.class);

    public static Map<InvocationType, InvocationInfo> getCurrentContext() {
        return InvocationContext.CONTEXT.get().context;
    }

    public static ImmutableMap<InvocationType, InvocationInfo> getCurrentContextImmutable() {
        return ImmutableMap.copyOf(InvocationContext.getCurrentContext());
    }

    public static Runnable propagateContext(Runnable runnable) {
        Preconditions.checkNotNull(runnable);
        Map<InvocationType, InvocationInfo> parentContext = InvocationContext.getCurrentContext();
        Map<InvocationType, InvocationInfo> context = InvocationContext.copy(parentContext);
        return new RunnableWithContext(runnable, context, parentContext);
    }

    public static <V> Callable<V> propagateContext(Callable<V> callable) {
        Preconditions.checkNotNull(callable);
        Map<InvocationType, InvocationInfo> parentContext = InvocationContext.getCurrentContext();
        Map<InvocationType, InvocationInfo> context = InvocationContext.copy(parentContext);
        return new CallableWithContext<V>(callable, context, parentContext);
    }

    public static <V> FutureCallback<V> propagateContext(FutureCallback<V> futureCallback) {
        Preconditions.checkNotNull(futureCallback);
        Map<InvocationType, InvocationInfo> parentContext = InvocationContext.getCurrentContext();
        Map<InvocationType, InvocationInfo> context = InvocationContext.copy(parentContext);
        return new FutureCallbackWithContext<V>(futureCallback, context, parentContext);
    }

    private InvocationContext() {
    }

    private static Map<InvocationType, InvocationInfo> copy(Map<InvocationType, InvocationInfo> map) {
        return map.isEmpty() ? new EnumMap<InvocationType, InvocationInfo>(InvocationType.class) : new EnumMap<InvocationType, InvocationInfo>(map);
    }

    private static class RunnableWithContext
    implements Runnable {
        private final Runnable runnable;
        private final Map<InvocationType, InvocationInfo> context;
        private final Object parentContext;

        private RunnableWithContext(Runnable runnable, Map<InvocationType, InvocationInfo> context, Object parentContext) {
            this.runnable = runnable;
            this.context = context;
            this.parentContext = parentContext;
        }

        @Override
        public void run() {
            if (InvocationContext.getCurrentContext() == this.parentContext) {
                this.runnable.run();
            } else {
                try (ContextScope ignored = new ContextScope(this.context);){
                    this.runnable.run();
                }
            }
        }
    }

    private static class CallableWithContext<V>
    implements Callable<V> {
        private final Callable<V> callable;
        private final Map<InvocationType, InvocationInfo> context;
        private final Object parentContext;

        private CallableWithContext(Callable<V> callable, Map<InvocationType, InvocationInfo> context, Object parentContext) {
            this.callable = callable;
            this.context = context;
            this.parentContext = parentContext;
        }

        @Override
        public V call() throws Exception {
            if (InvocationContext.getCurrentContext() == this.parentContext) {
                return this.callable.call();
            }
            try (ContextScope ignored = new ContextScope(this.context);){
                V v = this.callable.call();
                return v;
            }
        }
    }

    private static class FutureCallbackWithContext<V>
    implements FutureCallback<V> {
        private final FutureCallback<V> futureCallback;
        private final Map<InvocationType, InvocationInfo> context;
        private final Object parentContext;

        private FutureCallbackWithContext(FutureCallback<V> futureCallback, Map<InvocationType, InvocationInfo> context, Object parentContext) {
            this.futureCallback = futureCallback;
            this.context = context;
            this.parentContext = parentContext;
        }

        @Override
        public void onSuccess(V result) {
            if (InvocationContext.getCurrentContext() == this.parentContext) {
                this.futureCallback.onSuccess(result);
            } else {
                try (ContextScope ignored = new ContextScope(this.context);){
                    this.futureCallback.onSuccess(result);
                }
            }
        }

        @Override
        public void onFailure(Throwable t2) {
            if (InvocationContext.getCurrentContext() == this.parentContext) {
                this.futureCallback.onFailure(t2);
            } else {
                try (ContextScope ignored = new ContextScope(this.context);){
                    this.futureCallback.onFailure(t2);
                }
            }
        }
    }

    public static enum InvocationType {
        OMNILAB_TEST("test_id"),
        OMNILAB_JOB("job_id"),
        OLC_SESSION("olc_session_id"),
        OLC_CLIENT("olc_client_id");

        private final String displayName;

        private InvocationType(String displayName) {
            this.displayName = displayName;
        }

        public String displayName() {
            return this.displayName;
        }

        public String toString() {
            return this.displayName();
        }
    }

    public static class ContextScope
    implements NonThrowingAutoCloseable {
        private final Map<InvocationType, InvocationInfo> scopedContext;

        public ContextScope(Map<InvocationType, InvocationInfo> scopedContext) {
            this.scopedContext = InvocationContext.copy(scopedContext);
            InvocationContext.getCurrentContext().putAll(this.scopedContext);
        }

        @Override
        public void close() {
            Map<InvocationType, InvocationInfo> currentContext = InvocationContext.getCurrentContext();
            this.scopedContext.forEach((type, value) -> currentContext.remove(type));
        }
    }

    @AutoValue
    public static abstract class InvocationInfo {
        public abstract String id();

        public abstract String displayId();

        public final String toString() {
            return this.displayId();
        }

        public static InvocationInfo of(String id, String displayId) {
            return new AutoValue_InvocationContext_InvocationInfo(id, displayId);
        }

        public static InvocationInfo fromUuid(String uuid) {
            return InvocationInfo.of(uuid, uuid.substring(0, Math.min(8, uuid.length())));
        }

        public static InvocationInfo sameDisplayId(String id) {
            return InvocationInfo.of(id, id);
        }
    }
}

