/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite.retry;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.api.model.error.ExtErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.common.SessionRequestInfo;
import com.google.devtools.mobileharness.infra.ats.console.command.parser.CommandLineParser;
import com.google.devtools.mobileharness.infra.ats.console.result.proto.ReportProto;
import com.google.devtools.mobileharness.infra.ats.console.result.report.CompatibilityReportParser;
import com.google.devtools.mobileharness.infra.ats.console.result.report.TestResultProtoUtil;
import com.google.devtools.mobileharness.infra.ats.console.util.result.ResultListerHelper;
import com.google.devtools.mobileharness.platform.android.xts.suite.retry.AutoValue_PreviousResultLoader_TradefedResultFilesBundle;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class PreviousResultLoader {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String TEST_RECORD_PROTO_DIR_NAME = "proto";
    private final LocalFileUtil localFileUtil;
    private final ResultListerHelper resultListerHelper;
    private final CompatibilityReportParser compatibilityReportParser;

    @Inject
    PreviousResultLoader(LocalFileUtil localFileUtil, ResultListerHelper resultListerHelper, CompatibilityReportParser compatibilityReportParser) {
        this.localFileUtil = localFileUtil;
        this.resultListerHelper = resultListerHelper;
        this.compatibilityReportParser = compatibilityReportParser;
    }

    public ReportProto.Result loadPreviousResult(Path resultsDir, @Nullable Integer previousSessionIndex, @Nullable String previousSessionResultDirName) throws MobileHarnessException {
        Preconditions.checkState(previousSessionIndex != null || previousSessionResultDirName != null);
        Path testResultProtoFile = this.getPrevSessionTestResultProtoFile(resultsDir, previousSessionIndex, previousSessionResultDirName);
        if (this.localFileUtil.isFileExist(testResultProtoFile)) {
            return this.loadResult(testResultProtoFile, previousSessionIndex != null ? String.valueOf(previousSessionIndex) : previousSessionResultDirName);
        }
        Optional<ReportProto.Result> result = this.getPrevLegacySessionTestResult(resultsDir, previousSessionIndex, previousSessionResultDirName);
        if (result.isPresent()) {
            ((FluentLogger.Api)logger.atInfo()).log("Will retry legacy session result for session %s", previousSessionIndex != null ? previousSessionIndex : previousSessionResultDirName);
            return result.get();
        }
        throw new MobileHarnessException(ExtErrorId.PREV_RESULT_LOADER_MISSING_TEST_RESULT_XML_FILE_IN_SESSION, String.format("The test result xml file does not exist for session %s.", previousSessionIndex != null ? previousSessionIndex : previousSessionResultDirName));
    }

    public ReportProto.Result loadPreviousResult(Path resultDir, String previousSessionId) throws MobileHarnessException {
        Path testResultProtoFile = resultDir.resolve("test_result.pb");
        return this.loadResult(testResultProtoFile, previousSessionId);
    }

    private ReportProto.Result loadResult(Path testResultProtoFile, String previousSessionIdOrIndex) throws MobileHarnessException {
        try {
            return TestResultProtoUtil.readFromFile(testResultProtoFile.toFile());
        }
        catch (IOException e) {
            throw new MobileHarnessException(ExtErrorId.PREV_RESULT_LOADER_LOAD_TEST_RESULT_PROTO_FILE_ERROR, String.format("Failed to load test result proto file %s for session %s.", testResultProtoFile.toAbsolutePath(), previousSessionIdOrIndex), e);
        }
    }

    private Path getPrevSessionTestResultProtoFile(Path resultsDir, @Nullable Integer previousSessionIndex, @Nullable String previousSessionResultDirName) throws MobileHarnessException {
        return this.getPrevSessionResultDir(resultsDir, previousSessionIndex, previousSessionResultDirName).resolve("test_result.pb");
    }

    public Path getPrevSessionResultDir(Path resultsDir, @Nullable Integer previousSessionIndex, @Nullable String previousSessionResultDirName) throws MobileHarnessException {
        Preconditions.checkState(previousSessionIndex != null || previousSessionResultDirName != null);
        ImmutableList<File> allResultDirs = this.getAllResultDirs(resultsDir, previousSessionIndex, previousSessionResultDirName);
        if (previousSessionIndex != null) {
            return ((File)allResultDirs.get(previousSessionIndex)).toPath();
        }
        return allResultDirs.stream().filter(resultDir -> resultDir.getName().equals(previousSessionResultDirName)).findFirst().get().toPath();
    }

    private Optional<ReportProto.Result> getPrevLegacySessionTestResult(Path resultsDir, @Nullable Integer previousSessionIndex, @Nullable String previousSessionResultDirName) throws MobileHarnessException {
        Preconditions.checkState(previousSessionIndex != null || previousSessionResultDirName != null);
        Path prevSessionResultDir = this.getPrevSessionResultDir(resultsDir, previousSessionIndex, previousSessionResultDirName);
        List<File> testResultXmlFiles = this.localFileUtil.listFiles(prevSessionResultDir.toAbsolutePath().toString(), true, p -> p.getName().equals("test_result.xml"));
        if (testResultXmlFiles.size() != 1) {
            throw new MobileHarnessException(ExtErrorId.PREV_RESULT_LOADER_LOAD_LEGACY_TEST_RESULT_XML_FILE_ERROR, String.format("Failed to load legacy test result XML file under %s for session %s.", resultsDir.toAbsolutePath(), previousSessionIndex));
        }
        Optional<ReportProto.Result> result = this.compatibilityReportParser.parse(testResultXmlFiles.get(0).toPath(), false);
        return Optional.ofNullable(result.isPresent() ? this.injectArgsFromCommandLine(result.get()) : null);
    }

    private ReportProto.Result injectArgsFromCommandLine(ReportProto.Result result) throws MobileHarnessException {
        String commandLineArgsStr;
        Optional<ReportProto.Attribute> commandLineArgs = result.getAttributeList().stream().filter(attr -> attr.getKey().equals("command_line_args")).findFirst();
        String string = commandLineArgsStr = commandLineArgs.isPresent() ? commandLineArgs.get().getValue() : "";
        if (commandLineArgsStr.isEmpty()) {
            return result;
        }
        CommandLineParser parser = CommandLineParser.getInstance();
        SessionRequestInfo info = parser.parseCommandLine(commandLineArgsStr).setCommandLineArgs("").setXtsRootDir("").setXtsType("").build();
        ReportProto.Result.Builder resultBuilder = result.toBuilder();
        if (info.testName().isPresent()) {
            resultBuilder.setTestFilter(info.testName().get());
        }
        if (!info.moduleNames().isEmpty()) {
            resultBuilder.addAllModuleFilter(info.moduleNames());
        }
        if (!info.includeFilters().isEmpty()) {
            resultBuilder.addAllIncludeFilter(info.includeFilters());
        }
        if (!info.excludeFilters().isEmpty()) {
            resultBuilder.addAllExcludeFilter(info.excludeFilters());
        }
        return resultBuilder.build();
    }

    public Optional<TradefedResultFilesBundle> getPrevSessionResultFilesBundle(Path resultsDir, @Nullable Integer previousSessionIndex, @Nullable String previousSessionResultDirName) throws MobileHarnessException {
        Preconditions.checkState(previousSessionIndex != null || previousSessionResultDirName != null);
        Path prevSessionResultDir = this.getPrevSessionResultDir(resultsDir, previousSessionIndex, previousSessionResultDirName);
        Path testResultXmlFile = prevSessionResultDir.resolve("test_result.xml");
        if (!this.localFileUtil.isFileExist(testResultXmlFile)) {
            return Optional.empty();
        }
        Path testRecordProtoDir = prevSessionResultDir.resolve(TEST_RECORD_PROTO_DIR_NAME);
        if (!this.localFileUtil.isDirExist(testRecordProtoDir)) {
            return Optional.empty();
        }
        ImmutableList<Path> testRecordProtoFiles = ImmutableList.sortedCopyOf(this.localFileUtil.listFilesOrDirs(testRecordProtoDir, p -> p.toFile().isFile()));
        if (testRecordProtoFiles.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(TradefedResultFilesBundle.of(testResultXmlFile, testRecordProtoFiles));
    }

    public Optional<TradefedResultFilesBundle> getPrevSessionResultFilesBundle(Path resultDir) throws MobileHarnessException {
        Path testResultXmlFile = resultDir.resolve("test_result.xml");
        if (!this.localFileUtil.isFileExist(testResultXmlFile)) {
            return Optional.empty();
        }
        ImmutableList<Path> testRecordProtoFiles = this.getPrevSessionTestRecordProtoFiles(resultDir);
        if (testRecordProtoFiles.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(TradefedResultFilesBundle.of(testResultXmlFile, testRecordProtoFiles));
    }

    public Optional<Path> getPrevSessionTestReportProperties(Path resultsDir, @Nullable Integer previousSessionIndex, @Nullable String previousSessionResultDirName) throws MobileHarnessException {
        Preconditions.checkState(previousSessionIndex != null || previousSessionResultDirName != null);
        Path prevSessionResultDir = this.getPrevSessionResultDir(resultsDir, previousSessionIndex, previousSessionResultDirName);
        Optional<Path> testReportPropertiesFile = Optional.of(prevSessionResultDir.resolve("test-report.properties"));
        if (!this.localFileUtil.isFileExist(testReportPropertiesFile.get())) {
            testReportPropertiesFile = Optional.empty();
        }
        return testReportPropertiesFile;
    }

    public Optional<Path> getPrevSessionTestReportProperties(Path resultDir) throws MobileHarnessException {
        Path testReportPropertiesFile = resultDir.resolve("test-report.properties");
        if (!this.localFileUtil.isFileExist(testReportPropertiesFile)) {
            return Optional.empty();
        }
        return Optional.of(testReportPropertiesFile);
    }

    public ImmutableList<Path> getPrevSessionTestRecordProtoFiles(Path resultsDir, @Nullable Integer previousSessionIndex, @Nullable String previousSessionResultDirName) throws MobileHarnessException {
        Preconditions.checkState(previousSessionIndex != null || previousSessionResultDirName != null);
        Path prevSessionResultDir = this.getPrevSessionResultDir(resultsDir, previousSessionIndex, previousSessionResultDirName);
        Path testRecordProtoDir = prevSessionResultDir.resolve(TEST_RECORD_PROTO_DIR_NAME);
        if (!this.localFileUtil.isDirExist(testRecordProtoDir)) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.localFileUtil.listFilesOrDirs(testRecordProtoDir, p -> p.toFile().isFile()));
    }

    public ImmutableList<Path> getPrevSessionTestRecordProtoFiles(Path resultDir) throws MobileHarnessException {
        Path testRecordProtoDir = resultDir.resolve(TEST_RECORD_PROTO_DIR_NAME);
        if (!this.localFileUtil.isDirExist(testRecordProtoDir)) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.localFileUtil.listFilesOrDirs(testRecordProtoDir, p -> p.toFile().isFile()));
    }

    private ImmutableList<File> getAllResultDirs(Path resultsDir, @Nullable Integer previousSessionIndex, @Nullable String previousSessionResultDirName) throws MobileHarnessException {
        ImmutableList<File> allResultDirs = this.resultListerHelper.listResultDirsInOrder(resultsDir.toAbsolutePath().toString());
        if (allResultDirs.isEmpty()) {
            throw new MobileHarnessException(ExtErrorId.PREV_RESULT_LOADER_NO_PREVIOUS_SESSION_FOUND, "No previous session found.");
        }
        if (previousSessionIndex != null && (previousSessionIndex < 0 || previousSessionIndex >= allResultDirs.size())) {
            throw new MobileHarnessException(ExtErrorId.PREV_RESULT_LOADER_SESSION_INDEX_OUT_OF_RANGE, String.format("The given previous session index %s is out of index. The session index range is [%d, %d]", previousSessionIndex, 0, allResultDirs.size() - 1));
        }
        if (previousSessionResultDirName != null && allResultDirs.stream().noneMatch(resultDir -> resultDir.getName().equals(previousSessionResultDirName))) {
            throw new MobileHarnessException(ExtErrorId.PREV_RESULT_LOADER_SESSION_RESULT_DIR_NOT_FOUND, String.format("The given previous session result dir [%s] is not found in the result dir [%s].", previousSessionResultDirName, resultsDir));
        }
        return allResultDirs;
    }

    @AutoValue
    public static abstract class TradefedResultFilesBundle {
        public static TradefedResultFilesBundle of(Path testResultXml, ImmutableList<Path> testRecordProtoFiles) {
            return new AutoValue_PreviousResultLoader_TradefedResultFilesBundle(testResultXml, testRecordProtoFiles);
        }

        public abstract Path testResultXml();

        public abstract ImmutableList<Path> testRecordProtoFiles();
    }
}

