/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.FluentLogger;
import com.google.common.io.Files;
import com.google.devtools.mobileharness.api.model.error.ExtErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.platform.android.xts.common.util.AbiUtil;
import com.google.devtools.mobileharness.platform.android.xts.config.ConfigurationUtil;
import com.google.devtools.mobileharness.platform.android.xts.config.ConfigurationXmlParser;
import com.google.devtools.mobileharness.platform.android.xts.config.proto.ConfigurationProto;
import com.google.devtools.mobileharness.platform.android.xts.suite.Abi;
import com.google.devtools.mobileharness.platform.android.xts.suite.DeviceFoldableState;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.FoldableExpandingHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.IModuleParameterHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.ModuleParameters;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.ModuleParametersHelper;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.NegativeHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.NotMultiAbiHandler;
import com.google.protobuf.ProtocolStringList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXParseException;

public class SuiteModuleLoader {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String TEST_SUITE_PARAMETER_KEY = "parameter";
    private ModuleParameters forcedModuleParameter = null;
    private boolean allowParameterizedModules = false;
    private boolean allowOptionalParameterizedModules = false;
    private final Set<DeviceFoldableState> foldableStates = new LinkedHashSet<DeviceFoldableState>();
    private final ConfigurationUtil configurationUtil;

    public SuiteModuleLoader() {
        this(new ConfigurationUtil());
    }

    @VisibleForTesting
    SuiteModuleLoader(ConfigurationUtil configurationUtil) {
        this.configurationUtil = configurationUtil;
    }

    public void setModuleParameter(ModuleParameters param) {
        this.forcedModuleParameter = param;
    }

    public void setParameterizedModules(boolean allowed) {
        this.allowParameterizedModules = allowed;
    }

    public void setOptionalParameterizedModules(boolean allowed) {
        this.allowOptionalParameterizedModules = allowed;
    }

    public Map<String, ConfigurationProto.Configuration> loadConfigsFromDirectory(List<File> testsDirs, Set<Abi> abis, List<String> configFileExtensions) throws MobileHarnessException {
        LinkedHashMap<String, ConfigurationProto.Configuration> toRun = new LinkedHashMap<String, ConfigurationProto.Configuration>();
        ArrayList<File> listConfigFiles = new ArrayList<File>();
        listConfigFiles.addAll(this.configurationUtil.getConfigFilesFromDirsByExt(testsDirs, configFileExtensions));
        Collections.sort(listConfigFiles);
        toRun.putAll(this.loadConfigsFromSpecifiedPaths(listConfigFiles, abis));
        return toRun;
    }

    public Map<String, ConfigurationProto.Configuration> loadConfigsFromSpecifiedPaths(List<File> listConfigFiles, Set<Abi> abis) throws MobileHarnessException {
        LinkedHashMap<String, ConfigurationProto.Configuration> toRun = new LinkedHashMap<String, ConfigurationProto.Configuration>();
        for (File configFile : listConfigFiles) {
            toRun.putAll(this.loadOneConfig(configFile.getName(), configFile.getAbsolutePath(), abis));
        }
        return toRun;
    }

    private Map<String, ConfigurationProto.Configuration> loadOneConfig(String configName, String configFullName, Set<Abi> abis) throws MobileHarnessException {
        ConfigurationProto.Configuration config;
        LinkedHashMap<String, ConfigurationProto.Configuration> toRun = new LinkedHashMap<String, ConfigurationProto.Configuration>();
        String name = Files.getNameWithoutExtension(configName);
        File configFile = new File(configFullName);
        try {
            config = ConfigurationXmlParser.parse(configFile);
        }
        catch (MobileHarnessException e) {
            if (e.getCause() instanceof SAXParseException) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause(e)).log("Failed to parse config file %s", configFile.getAbsolutePath());
                return toRun;
            }
            throw e;
        }
        boolean primaryAbi = true;
        boolean shouldCreateMultiAbi = true;
        boolean hasForcedModuleParameter = false;
        HashSet forcedModuleParameterHandlerClasses = null;
        if (this.forcedModuleParameter != null) {
            hasForcedModuleParameter = true;
            ImmutableMap<ModuleParameters, IModuleParameterHandler> moduleParameters = ModuleParametersHelper.resolveParam(this.forcedModuleParameter, this.allowOptionalParameterizedModules);
            forcedModuleParameterHandlerClasses = new HashSet();
            for (IModuleParameterHandler parameter : moduleParameters.values()) {
                if (parameter instanceof FoldableExpandingHandler) {
                    for (IModuleParameterHandler fParam : ((FoldableExpandingHandler)parameter).expandHandler(this.foldableStates)) {
                        forcedModuleParameterHandlerClasses.add(fParam.getClass());
                    }
                    continue;
                }
                forcedModuleParameterHandlerClasses.add(parameter.getClass());
            }
        }
        for (Abi abi : abis) {
            if (!shouldCreateMultiAbi && !primaryAbi) continue;
            String baseId = AbiUtil.createId(abi.name(), name);
            boolean skipCreatingBaseConfig = false;
            List<IModuleParameterHandler> paramHandlers = this.getModuleParameters(name, config);
            shouldCreateMultiAbi = this.shouldCreateMultiAbiForBase(paramHandlers);
            if (this.allowParameterizedModules) {
                for (IModuleParameterHandler paramHandler : paramHandlers) {
                    if (paramHandler instanceof NegativeHandler) {
                        if (!hasForcedModuleParameter || forcedModuleParameterHandlerClasses.contains(paramHandler.getClass())) continue;
                        skipCreatingBaseConfig = true;
                        continue;
                    }
                    if (hasForcedModuleParameter) {
                        if (!forcedModuleParameterHandlerClasses.contains(paramHandler.getClass())) continue;
                        skipCreatingBaseConfig = true;
                    }
                    if (!primaryAbi) continue;
                    String fullId = String.format("%s[%s]", baseId, paramHandler.getParameterIdentifier());
                    ConfigurationProto.Configuration paramConfig = ConfigurationXmlParser.parse(configFile);
                    toRun.put(fullId, paramConfig);
                }
            }
            primaryAbi = false;
            if (skipCreatingBaseConfig) continue;
            toRun.put(baseId, config);
        }
        return toRun;
    }

    private List<IModuleParameterHandler> getModuleParameters(String moduleName, ConfigurationProto.Configuration config) throws MobileHarnessException {
        ArrayList<IModuleParameterHandler> params = new ArrayList<IModuleParameterHandler>();
        HashSet<String> processedParameterArgs = new HashSet<String>();
        LinkedHashMap<String, ModuleParameters> duplicateModule = new LinkedHashMap<String, ModuleParameters>();
        ProtocolStringList parameters = config.getConfigDescriptor().getMetadataMap().getOrDefault(TEST_SUITE_PARAMETER_KEY, ConfigurationProto.ConfigurationDescriptorMetadata.getDefaultInstance()).getValueList();
        if (parameters.isEmpty()) {
            return params;
        }
        for (String p : parameters) {
            if (!processedParameterArgs.add(p)) continue;
            ImmutableMap<ModuleParameters, IModuleParameterHandler> suiteParams = ModuleParametersHelper.resolveParam(ModuleParameters.valueOf(Ascii.toUpperCase(p)), this.allowOptionalParameterizedModules);
            for (Map.Entry suiteParamEntry : suiteParams.entrySet()) {
                ModuleParameters suiteParam = (ModuleParameters)((Object)suiteParamEntry.getKey());
                String family = suiteParam.getFamily();
                if (duplicateModule.containsKey(family)) {
                    throw new MobileHarnessException(ExtErrorId.SUITE_MODULE_LOADER_DUPLICATED_FAMILY_MEMBERS, String.format("Module %s is declaring parameter: %s and %s when only one expected.", new Object[]{moduleName, suiteParam, duplicateModule.get(family)}));
                }
                duplicateModule.put(suiteParam.getFamily(), suiteParam);
                if (suiteParamEntry.getValue() instanceof FoldableExpandingHandler) {
                    List<IModuleParameterHandler> foldableHandlers = ((FoldableExpandingHandler)suiteParamEntry.getValue()).expandHandler(this.foldableStates);
                    params.addAll(foldableHandlers);
                    continue;
                }
                params.add((IModuleParameterHandler)suiteParamEntry.getValue());
            }
        }
        return params;
    }

    private boolean shouldCreateMultiAbiForBase(List<IModuleParameterHandler> params) {
        for (IModuleParameterHandler param : params) {
            if (!(param instanceof NotMultiAbiHandler)) continue;
            return false;
        }
        return true;
    }
}

