/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.common.util;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.platform.android.xts.common.util.XtsDirUtil;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import com.google.devtools.mobileharness.shared.util.system.SystemUtil;
import java.nio.file.Path;

public final class XtsCommandUtil {
    private static final String COMPATIBILITY_CONSOLE_CLASS = "com.android.compatibility.common.tradefed.command.CompatibilityConsole";
    private static final SystemUtil SYSTEM_UTIL = new SystemUtil();
    private static final LocalFileUtil LOCAL_FILE_UTIL = new LocalFileUtil();

    public static ImmutableList<String> getTradefedJavaCommand(String javaBinary, ImmutableList<String> jvmFlags, String concatenatedJarPath, ImmutableList<String> jvmDefines, String mainClass, ImmutableList<String> xtsRunCommandArgs) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(javaBinary)).addAll(jvmFlags)).add("-cp")).add(concatenatedJarPath)).addAll(jvmDefines)).add(mainClass)).addAll(xtsRunCommandArgs)).build();
    }

    public static String getConsoleClassName() {
        return COMPATIBILITY_CONSOLE_CLASS;
    }

    public static String getXtsRootJavaProperty(String xtsType, Path xtsRootDir) {
        return String.format("-D%s_ROOT=%s", Ascii.toUpperCase(xtsType).replace('-', '_'), xtsRootDir);
    }

    public static Path getJavaBinary(String xtsType, Path xtsRootDir) {
        if (XtsCommandUtil.useXtsJavaBinary(xtsType, xtsRootDir)) {
            return XtsDirUtil.getXtsJavaBinary(xtsRootDir, xtsType);
        }
        return Path.of(SYSTEM_UTIL.getJavaBin(), new String[0]);
    }

    public static boolean useXtsJavaBinary(String xtsType, Path xtsRootDir) {
        return SYSTEM_UTIL.isOnLinux() && SYSTEM_UTIL.isX8664() && LOCAL_FILE_UTIL.isFileExist(XtsDirUtil.getXtsJavaBinary(xtsRootDir, xtsType));
    }

    private XtsCommandUtil() {
    }
}

