/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.util.version;

import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.platform.android.xts.suite.TestSuiteInfo;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import java.nio.file.Path;
import java.util.Optional;
import javax.inject.Inject;

class VersionParser {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String DEFAULT_IMPLEMENTATION_VERSION = "default";
    private static final String VERSION_FILE = "version.txt";
    private final LocalFileUtil localFileUtil;

    @Inject
    VersionParser(LocalFileUtil localFileUtil) {
        this.localFileUtil = localFileUtil;
    }

    Optional<String> fetchVersion(TestSuiteInfo testSuiteInfo) {
        String packageVersion;
        Package pkg = VersionParser.class.getPackage();
        if (pkg != null && (packageVersion = pkg.getImplementationVersion()) != null && !packageVersion.equals(DEFAULT_IMPLEMENTATION_VERSION)) {
            return Optional.of(packageVersion);
        }
        Path toolsDir = testSuiteInfo.getToolsDir();
        Path versionFile = toolsDir.resolve(VERSION_FILE);
        if (this.localFileUtil.isFileExist(versionFile)) {
            try {
                String version = this.localFileUtil.readFile(versionFile);
                return Optional.of(version.trim());
            }
            catch (MobileHarnessException e) {
                ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).withCause(e)).log("Cannot read %s in directory: %s", (Object)VERSION_FILE, (Object)toolsDir);
                return Optional.empty();
            }
        }
        ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Did not find %s in directory: %s", (Object)VERSION_FILE, (Object)toolsDir);
        return Optional.empty();
    }
}

