/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.util.result;

import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.console.ConsoleInfo;
import com.google.devtools.mobileharness.infra.ats.console.result.proto.ReportProto;
import com.google.devtools.mobileharness.infra.ats.console.util.result.ResultListerHelper;
import com.google.devtools.mobileharness.platform.android.xts.common.util.XtsDirUtil;
import com.google.devtools.mobileharness.shared.util.base.TableFormatter;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ResultLister {
    private final ResultListerHelper resultListerHelper;
    private final ConsoleInfo consoleInfo;

    @Inject
    ResultLister(ResultListerHelper resultListerHelper, ConsoleInfo consoleInfo) {
        this.resultListerHelper = resultListerHelper;
        this.consoleInfo = consoleInfo;
    }

    public String listResults(String xtsType) throws MobileHarnessException {
        Path xtsRootDir = this.consoleInfo.getXtsRootDirectoryNonEmpty();
        String resultsDir = XtsDirUtil.getXtsResultsDir(xtsRootDir, xtsType).toString();
        ImmutableList<ResultListerHelper.ResultBundle> results = this.resultListerHelper.listResults(resultsDir);
        if (results.isEmpty()) {
            return "No results found";
        }
        ArrayList<ImmutableList<String>> table = new ArrayList<ImmutableList<String>>();
        table.add(ImmutableList.of("Session", "Pass", "Fail", "Modules Complete", "Result Directory", "Test Plan", "Device serial(s)", "Build ID", "Product"));
        int i = 0;
        for (ResultListerHelper.ResultBundle resultBundle : results) {
            File resultDir = resultBundle.resultDir();
            ReportProto.Result result = resultBundle.result();
            Map<String, ImmutableList<String>> attributes = result.getAttributeList().stream().collect(Collectors.groupingBy(ReportProto.Attribute::getKey, Collectors.mapping(ReportProto.Attribute::getValue, ImmutableList.toImmutableList())));
            Map<String, ImmutableList<String>> buildInfoAttributes = result.getBuild().getAttributeList().stream().collect(Collectors.groupingBy(ReportProto.Attribute::getKey, Collectors.mapping(ReportProto.Attribute::getValue, ImmutableList.toImmutableList())));
            table.add(ImmutableList.of(Integer.toString(i), Long.toString(result.getSummary().getPassed()), Long.toString(result.getSummary().getFailed()), String.format("%d of %d", result.getSummary().getModulesDone(), result.getSummary().getModulesTotal()), resultDir.getName(), ResultLister.getAttribute(attributes, "suite_plan"), ResultLister.getAttribute(attributes, "devices").replace(",", ", "), ResultLister.getAttribute(buildInfoAttributes, "build_id"), ResultLister.getAttribute(buildInfoAttributes, "build_product")));
            ++i;
        }
        return TableFormatter.displayTable(table);
    }

    private static String getAttribute(Map<String, ImmutableList<String>> attributes, String key) {
        ImmutableList<String> values = attributes.get(key);
        return values == null ? "unknown" : (String)values.get(0);
    }
}

