/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.result.report;

import com.google.devtools.mobileharness.infra.ats.console.result.report.CertificationSuiteInfo;
import com.google.devtools.mobileharness.platform.android.xts.suite.TestSuiteInfo;
import com.google.devtools.mobileharness.platform.android.xts.suite.TestSuiteInfoProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CertificationSuiteInfoFactory {
    public static final String SUITE_REPORT_VERSION = "5.0";

    public CertificationSuiteInfo createSuiteInfo(Map<String, String> suiteInfo) {
        CertificationSuiteInfo.Builder certificationSuiteInfoBuilder = CertificationSuiteInfo.builder();
        if (suiteInfo.containsKey("suite_name")) {
            certificationSuiteInfoBuilder.setSuiteName(suiteInfo.get("suite_name"));
        }
        if (suiteInfo.containsKey("suite_variant")) {
            certificationSuiteInfoBuilder.setSuiteVariant(suiteInfo.get("suite_variant"));
        }
        if (suiteInfo.containsKey("suite_version")) {
            certificationSuiteInfoBuilder.setSuiteVersion(suiteInfo.get("suite_version"));
        }
        if (suiteInfo.containsKey("suite_plan")) {
            certificationSuiteInfoBuilder.setSuitePlan(suiteInfo.get("suite_plan"));
        }
        if (suiteInfo.containsKey("suite_build")) {
            certificationSuiteInfoBuilder.setSuiteBuild(suiteInfo.get("suite_build"));
        }
        certificationSuiteInfoBuilder.setSuiteReportVersion(SUITE_REPORT_VERSION);
        return certificationSuiteInfoBuilder.build();
    }

    public Map<String, String> generateSuiteInfoMap(String xtsRootDir, String xtsType, String suitePlan) {
        TestSuiteInfo testSuiteInfo = TestSuiteInfoProvider.getTestSuiteInfo(xtsRootDir, xtsType);
        HashMap<String, String> suiteInfoMap = new HashMap<String, String>();
        suiteInfoMap.put("suite_name", testSuiteInfo.getName());
        suiteInfoMap.put("suite_variant", this.getSuiteVariant(suitePlan, testSuiteInfo.getName()));
        suiteInfoMap.put("suite_version", testSuiteInfo.getVersion());
        suiteInfoMap.put("suite_plan", suitePlan);
        suiteInfoMap.put("suite_build", testSuiteInfo.getBuildNumber());
        return suiteInfoMap;
    }

    public String getSuiteVariant(String suitePlan, String defaultValue) {
        return this.createSuiteVariant(suitePlan).orElse(defaultValue);
    }

    private Optional<String> createSuiteVariant(String suitePlan) {
        for (SuiteVariant var : SuiteVariant.values()) {
            if (!suitePlan.equals(var.getConfigName())) continue;
            return Optional.of(var.getReportDisplayName());
        }
        return Optional.empty();
    }

    private static enum SuiteVariant {
        CTS_ON_GSI("CTS_ON_GSI", "cts-on-gsi");

        private final String reportDisplayName;
        private final String configName;

        private SuiteVariant(String reportName, String configName) {
            this.reportDisplayName = reportName;
            this.configName = configName;
        }

        public String getReportDisplayName() {
            return this.reportDisplayName;
        }

        public String getConfigName() {
            return this.configName;
        }
    }
}

