/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command.preprocessor;

import com.google.common.collect.ImmutableList;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.api.model.error.InfraErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.shell.ShellUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class CommandFileParser {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final Pattern MACRO_PATTERN = Pattern.compile("([a-z][a-z0-9_-]*)\\(\\)", 2);
    private final Map<String, CommandLine> macros = new HashMap<String, CommandLine>();
    private final Map<String, List<CommandLine>> longMacros = new HashMap<String, List<CommandLine>>();
    private final List<CommandLine> lines = new ArrayList<CommandLine>();
    private final Set<String> includedFiles = new HashSet<String>();

    CommandFileParser() {
    }

    private static boolean isLineMacro(CommandLine line) {
        return line.size() >= 4 && "MACRO".equals(line.get(0)) && "=".equals(line.get(2));
    }

    private static boolean isLineLongMacro(CommandLine line) {
        return line.size() == 3 && "LONG".equals(line.get(0)) && "MACRO".equals(line.get(1));
    }

    private static boolean isLineIncludeDirective(CommandLine line) {
        return line.size() == 2 && "INCLUDE".equals(line.get(0));
    }

    private static boolean shouldParseLine(String line) {
        return !(line = line.trim()).isEmpty() && !line.startsWith("#");
    }

    public Set<String> getIncludedFiles() {
        return this.includedFiles;
    }

    private void scanFile(File file) throws MobileHarnessException {
        if (this.includedFiles.contains(file.getAbsolutePath())) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atFiner()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Skipping repeated include of file %s.", file);
            return;
        }
        this.includedFiles.add(file.getAbsolutePath());
        int lineNumber = 0;
        try (BufferedReader fileReader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            String inputLine;
            while ((inputLine = fileReader.readLine()) != null) {
                List<String> prev;
                CommandLine expansion;
                String name;
                ++lineNumber;
                if (!CommandFileParser.shouldParseLine(inputLine = inputLine.trim())) continue;
                CommandLine args = new CommandLine(ShellUtils.tokenize(inputLine), file, lineNumber);
                if (CommandFileParser.isLineMacro(args)) {
                    name = (String)args.get(1);
                    prev = this.macros.put(name, expansion = new CommandLine(args.subList(3, args.size()), file, lineNumber));
                    if (prev == null) continue;
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Overwrote short macro '%s' while parsing file %s", (Object)name, (Object)file);
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("value '%s' replaced previous value '%s'", (Object)expansion, (Object)prev);
                    continue;
                }
                if (CommandFileParser.isLineLongMacro(args)) {
                    name = (String)args.get(2);
                    expansion = new ArrayList();
                    inputLine = fileReader.readLine();
                    ++lineNumber;
                    while (!Objects.equals(inputLine, "END MACRO")) {
                        if (inputLine == null) {
                            throw new MobileHarnessException(InfraErrorId.ATSC_CMDFILE_PARSE_ERROR, String.format("Syntax error: Unexpected EOF while reading definition for LONG MACRO %s.", name));
                        }
                        if (CommandFileParser.shouldParseLine(inputLine)) {
                            CommandLine line = new CommandLine(ShellUtils.tokenize(inputLine), file, lineNumber);
                            expansion.add(line);
                        }
                        inputLine = fileReader.readLine();
                        ++lineNumber;
                    }
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Parsed %d-line definition for long macro %s", expansion.size(), (Object)name);
                    prev = this.longMacros.put(name, expansion);
                    if (prev == null) continue;
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Overwrote long macro %s while parsing file %s", (Object)name, (Object)file);
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("%d-line definition replaced previous %d-line definition", expansion.size(), prev.size());
                    continue;
                }
                if (CommandFileParser.isLineIncludeDirective(args)) {
                    File toScan = new File((String)args.get(1));
                    if (toScan.isAbsolute()) {
                        ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Got an include directive for absolute path %s.", args.get(1));
                    } else {
                        File parent = file.getParentFile();
                        toScan = new File(parent, (String)args.get(1));
                        ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Got an include directive for relative path %s, using '%s' for parent dir", args.get(1), (Object)parent);
                    }
                    this.scanFile(toScan);
                    continue;
                }
                this.lines.add(args);
            }
        }
        catch (IOException e) {
            throw new MobileHarnessException(InfraErrorId.ATSC_CMDFILE_READ_ERROR, String.format("Failed to read file %s", file), e);
        }
        catch (ShellUtils.TokenizationException e) {
            throw new MobileHarnessException(InfraErrorId.ATSC_CMDFILE_PARSE_ERROR, String.format("Failed to parse line %s of file %s", lineNumber, file), e);
        }
    }

    public List<CommandLine> parseFile(File file) throws MobileHarnessException {
        this.includedFiles.clear();
        this.macros.clear();
        this.longMacros.clear();
        this.lines.clear();
        this.scanFile(file);
        this.includedFiles.remove(file.getAbsolutePath());
        Bitmask inputBitmask = new Bitmask(this.lines.size(), true);
        for (int iCount = 0; iCount < 20 && inputBitmask.getSetCount() > 0; ++iCount) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("### Expansion iteration %d", iCount);
            int inputIdx = 0;
            while (inputIdx < this.lines.size()) {
                CommandLine line;
                if (!inputBitmask.get(inputIdx)) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("skipping input line %s", this.lines.get(inputIdx));
                    ++inputIdx;
                    continue;
                }
                boolean sawMacro = this.expandMacro(line = this.lines.get(inputIdx));
                List<CommandLine> longMacroExpansion = this.expandLongMacro(line, !sawMacro);
                if (longMacroExpansion == null) {
                    if (!sawMacro) {
                        boolean bl = inputBitmask.unset(inputIdx);
                    }
                    ++inputIdx;
                    continue;
                }
                CommandLine unused1 = this.lines.remove(inputIdx);
                boolean unused2 = inputBitmask.remove(inputIdx);
                this.lines.addAll(inputIdx, longMacroExpansion);
                inputBitmask.addN(inputIdx, longMacroExpansion.size(), true);
                inputIdx += longMacroExpansion.size();
            }
        }
        return this.lines;
    }

    @Nullable
    private List<CommandLine> expandLongMacro(CommandLine line, boolean checkMissingMacro) throws MobileHarnessException {
        for (int idx = 0; idx < line.size(); ++idx) {
            String token = (String)line.get(idx);
            Matcher matchMacro = MACRO_PATTERN.matcher(token);
            if (!matchMacro.matches()) continue;
            ArrayList<CommandLine> expansion = new ArrayList<CommandLine>();
            String name = matchMacro.group(1);
            List<CommandLine> longMacro = this.longMacros.get(name);
            if (longMacro == null) {
                if (checkMissingMacro) {
                    throw new MobileHarnessException(InfraErrorId.ATSC_CMDFILE_PARSE_ERROR, String.format("Macro call '%s' does not match any macro definitions.", name));
                }
                ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Macro call '%s' doesn't match any long macro definitions.", name);
                return null;
            }
            ArrayList prefix = new ArrayList(line.subList(0, idx));
            ArrayList suffix = new ArrayList(line.subList(idx, line.size()));
            suffix.remove(0);
            for (CommandLine macroLine : longMacro) {
                CommandLine expanded = new CommandLine(ImmutableList.of(), line.getFile(), line.getLineNumber());
                expanded.addAll(prefix);
                expanded.addAll(macroLine);
                expanded.addAll(suffix);
                expansion.add(expanded);
            }
            return expansion;
        }
        return null;
    }

    private boolean expandMacro(CommandLine line) {
        boolean sawMacro = false;
        int idx = 0;
        while (idx < line.size()) {
            String token = (String)line.get(idx);
            Matcher matchMacro = MACRO_PATTERN.matcher(token);
            if (matchMacro.matches() && this.macros.containsKey(matchMacro.group(1))) {
                String name = matchMacro.group(1);
                CommandLine macro = this.macros.get(name);
                ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Gotcha!  Expanding macro '%s' to '%s'", (Object)name, (Object)macro);
                line.remove(idx);
                line.addAll(idx, macro);
                idx += macro.size();
                sawMacro = true;
                continue;
            }
            ++idx;
        }
        return sawMacro;
    }

    static class CommandLine
    extends ArrayList<String> {
        private final File file;
        private final int lineNumber;

        CommandLine(List<String> c, File file, int lineNumber) {
            super(c);
            this.file = file;
            this.lineNumber = lineNumber;
        }

        public File getFile() {
            return this.file;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof CommandLine) {
                CommandLine otherLine = (CommandLine)o;
                return super.equals(o) && Objects.equals(otherLine.getFile(), this.file) && otherLine.getLineNumber() == this.lineNumber;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int listHash = super.hashCode();
            return Objects.hash(listHash, this.file, this.lineNumber);
        }
    }

    static class Bitmask {
        private final List<Boolean> bitmask = new ArrayList<Boolean>();
        private int numBitsSet = 0;

        public Bitmask(int nBits, boolean initialValue) {
            for (int i = 0; i < nBits; ++i) {
                this.bitmask.add(initialValue);
            }
            if (initialValue) {
                this.numBitsSet = nBits;
            }
        }

        public int getSetCount() {
            return this.numBitsSet;
        }

        public boolean get(int idx) {
            return this.bitmask.get(idx);
        }

        public boolean set(int idx) {
            boolean retVal = this.bitmask.set(idx, true);
            if (!retVal) {
                ++this.numBitsSet;
            }
            return retVal;
        }

        public boolean unset(int idx) {
            boolean retVal = this.bitmask.set(idx, false);
            if (retVal) {
                --this.numBitsSet;
            }
            return retVal;
        }

        public boolean remove(int idx) {
            boolean retVal = this.bitmask.remove(idx);
            if (retVal) {
                --this.numBitsSet;
            }
            return retVal;
        }

        public void add(int idx, boolean val) {
            this.bitmask.add(idx, val);
            if (val) {
                ++this.numBitsSet;
            }
        }

        public void addN(int idx, int count, boolean val) {
            for (int i = 0; i < count; ++i) {
                this.add(idx, val);
            }
        }
    }
}

