/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command.completer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.infra.ats.console.command.completer.CommandCompleter;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class CommandCompleterHolder
implements Completer {
    private static final CommandCompleterHolder INSTANCE = new CommandCompleterHolder();
    private final AtomicReference<CommandCompleter> completer = new AtomicReference();

    public static CommandCompleterHolder getInstance() {
        return INSTANCE;
    }

    private CommandCompleterHolder() {
    }

    public void initialize(CommandCompleter completer) {
        this.completer.compareAndSet(null, Preconditions.checkNotNull(completer));
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        CommandCompleter completer = this.completer.get();
        if (completer != null) {
            ImmutableList<Candidate> result = completer.complete(line);
            candidates.addAll(result);
        }
    }
}

