/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command.completer;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.devtools.mobileharness.infra.ats.common.plan.PlanConfigUtil;
import com.google.devtools.mobileharness.infra.ats.console.util.plan.PlanHelper;
import com.google.devtools.mobileharness.shared.util.concurrent.Callables;
import com.google.devtools.mobileharness.shared.util.concurrent.MoreFutures;
import java.util.List;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jline.reader.Candidate;
import org.jline.reader.ParsedLine;

@Singleton
public class CommandCompleter {
    private final ListeningExecutorService threadPool;
    private final PlanHelper planHelper;
    private final SettableFuture<ImmutableList<Candidate>> listTestPlansFuture = SettableFuture.create();

    @Inject
    CommandCompleter(ListeningExecutorService threadPool, PlanHelper planHelper) {
        this.threadPool = threadPool;
        this.planHelper = planHelper;
    }

    public void startListingTestPlans() {
        this.listTestPlansFuture.setFuture(Futures.catching(MoreFutures.logFailure(this.threadPool.submit(Callables.threadRenaming(this::listTestPlans, () -> "test-plans-lister")), Level.WARNING, "Fatal error when listing test plans", new Object[0]), Throwable.class, error -> ImmutableList.of(), MoreExecutors.directExecutor()));
    }

    ImmutableList<Candidate> complete(ParsedLine line) {
        List<String> words = line.words();
        if (words.size() == 1) {
            return ImmutableList.of(new Candidate("run"));
        }
        if (words.size() > 1 && Ascii.equalsIgnoreCase(words.get(0), "run") && this.listTestPlansFuture.isDone()) {
            return Futures.getUnchecked(this.listTestPlansFuture);
        }
        return ImmutableList.of();
    }

    private ImmutableList<Candidate> listTestPlans() {
        ImmutableMap<String, PlanConfigUtil.PlanConfigInfo> testPlans = this.planHelper.listPlans();
        return testPlans.keySet().stream().map(Candidate::new).collect(ImmutableList.toImmutableList());
    }
}

