/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.api.model.error;

import com.google.common.base.Throwables;
import com.google.devtools.mobileharness.api.model.error.ErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class MobileHarnessExceptions {
    public static void check(boolean expression, ErrorId errorId, Supplier<String> errorMessage) throws MobileHarnessException {
        if (!expression) {
            throw new MobileHarnessException(errorId, errorMessage.get());
        }
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T reference, ErrorId errorId, @Nullable Object message) throws MobileHarnessException {
        if (reference == null) {
            throw new MobileHarnessException(errorId, String.valueOf(message));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T rethrow(@Nullable Throwable throwable, ErrorId defaultError) throws MobileHarnessException, InterruptedException {
        if (throwable != null) {
            Throwables.throwIfInstanceOf(throwable, MobileHarnessException.class);
            Throwables.throwIfInstanceOf(throwable, InterruptedException.class);
            Throwables.throwIfUnchecked(throwable);
        }
        throw new MobileHarnessException(defaultError, String.format("Unexpected non-MH checked exception [%s]", throwable == null ? null : throwable.getClass().getName()), throwable);
    }

    private MobileHarnessExceptions() {
    }
}

