/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.api.model.error;

import com.google.common.base.Preconditions;
import com.google.devtools.common.metrics.stability.model.proto.ErrorTypeProto;
import com.google.devtools.common.metrics.stability.util.ErrorIdFormatter;
import com.google.devtools.mobileharness.api.model.error.ErrorId;

public enum ExtErrorId implements ErrorId
{
    MOBLY_SPONGE_OUTPUT_PARSING_ERROR(81001, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TESTBED_SUBDEVICE_CALLABLE_ERROR(81002, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_TESTBED_ADHOC_DRIVER_END_WITH_UNKNOWN_RESULT(81003, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_FAILED_TO_FIND_CONFIG_FILE_ERROR(81004, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_FAILED_TO_READ_TESTBED_CONFIG_ERROR(81005, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TESTBED_CONFIG_MISSING_KEY_ERROR(81006, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TESTBED_CONFIG_PARSING_ERROR(81007, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_INVALID_TESTBED_MODEL_CONFIG_ERROR(81008, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_INVALID_TESTBED_CONTROLLER_CONFIG_ERROR(81009, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_CONFIG_GENERATION_ERROR(81010, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_FAILED_TO_CREATE_TEMP_DIRECTORY_ERROR(81011, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TESTBED_NAME_EMPTY_ERROR(81012, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_EXECUTE_ERROR(81013, ErrorTypeProto.ErrorType.UNDETERMINED),
    MOBLY_OUTPUT_PARSING_ERROR(81014, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_MISC_TESTBED_SUBDEVICE_JSON_TYPE_NAME_ERROR(81015, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_SUBDEVICE_TYPE_NOT_FOUND_ERROR(81016, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_TESTBED_ADHOC_DRIVER_SUBTEST_WITH_INFRA_ERROR_RESULT(81017, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_TESTBED_ADHOC_DRIVER_SUBTEST_WITH_DEPENDENCY_ERROR_RESULT(81018, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    MOBLY_TESTBED_ADHOC_DRIVER_SUBTEST_WITH_CUSTOMER_ERROR_RESULT(81019, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TESTBED_ADHOC_DRIVER_SUBTEST_WITH_UNDETERMINED_ERROR_RESULT(81020, ErrorTypeProto.ErrorType.UNDETERMINED),
    MOBLY_TESTBED_ADHOC_DRIVER_SUBTEST_WITH_FAIL_RESULT(81021, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TEST_FAILURE(81022, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TEST_TIMEOUT(81023, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TEST_SUMMARY_YAML_PARSING_ERROR(81024, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_TEST_SCRIPT_ERROR(81025, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_COMMAND_OUTPUT_EMPTY(81026, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_FAILED_TO_READ_COMMAND_OUTPUT(81027, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_TEST_CASE_FAILURE(81028, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TEST_CASE_ERROR(81029, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TEST_CASE_SKIPPED(81030, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TEST_SUMMARY_YAML_CONVERT_XML_ERROR(81031, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_SPONGE_XML_MISSING_ERROR(81032, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_SDK_TOOL_NOT_FOUND_ERROR(81033, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TEST_SUMMARY_YAML_MISSING_ERROR(81034, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_TESTBED_REBOOT_ERROR(81035, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_TESTBED_TEAR_DOWN_ERROR(81036, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_TESTBED_POST_RUN_TEST_ERROR(81037, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_TESTBED_PRE_RUN_TEST_ERROR(81038, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_TESTBED_CHECK_DEVICE_ERROR(81039, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_TESTBED_SET_UP_ERROR(81040, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_TESTBED_PARSING_ERROR(81041, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_TESTBED_CONFIG_ERROR(81042, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_LAB_GLIBC_ERROR(81043, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_COMMAND_OUTPUT_LOG_MISSING(81044, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    MOBLY_TEST_CRASH(81045, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_PLUGIN_ERROR(81046, ErrorTypeProto.ErrorType.UNDETERMINED),
    MOBLY_AOSP_CREATE_VENV_ERROR(81081, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_AOSP_PYTHON_VERSION_NOT_FOUND_ERROR(81082, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_AOSP_UNZIP_TEST_PACKAGE_ERROR(81083, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_AOSP_RESOLVE_TEST_PATH_ERROR(81084, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_AOSP_PIP_INSTALL_ERROR(81085, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_AOSP_MISSING_OUTPUT_ERROR(81086, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_AOSP_SPONGE_CONVERTER_ERROR(81087, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_AOSP_RESOLVE_TEST_EXECUTION_COMMAND_ERROR(81088, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    NO_OP_DRIVER_NON_PASSING_RESULT_SET_BY_MESSAGE(83401, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    NO_OP_DRIVER_NON_PASSING_RESULT_SET_BY_PARAM(83402, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    NO_OP_DRIVER_TEST_MESSAGE_ILLEGAL_ARGUMENT(83403, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    NO_OP_DRIVER_TEST_MESSAGE_ERROR(83404, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_CONFIG_TESTBED_ID_NOT_EXIST_ERROR(84501, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_CONFIG_SUBDEVICE_NOT_EXIST_ERROR(84502, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_CONFIG_TESTBED_SUBDEVICE_SAME_NAME_ERROR(84503, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_PARSING_TYPE_NOT_EXIST_ERROR(84504, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_PARSING_ID_NOT_EXIST_ERROR(84505, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_PARSING_NAME_NOT_EXIST_ERROR(84506, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_PARSING_DEVICE_NOT_EXIST_ERROR(84507, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_PARSING_DEVICE_KEY_NOT_EXIST_ERROR(84508, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_CONFIG_SUBDEVICE_ID_EMPTY_ERROR(84509, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_YAML_PARSING_ERROR(84510, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_CONFIG_DUPLICATE_ID_ERROR(84511, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_DEVICE_DECORATOR_NOT_COMPATIBLE_ERROR(84512, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_DEVICE_DECORATOR_SETUP_ERROR(84513, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_RUN_SUB_PARRALLEL_DEVICE_STACK_ERROR(84514, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    TESTBED_DEVICE_SYNCHRONIZATION_DRIVER_ERROR(84515, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    COMPOSITE_DEVICE_DECORATOR_ADAPTER_DECORATOR_JOB_PARAM_ERROR(84516, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MOBLY_DECORATOR_ADAPTER_DECORATOR_SPEC_ERROR(84551, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_DECORATOR_ADAPTER_DECORATOR_DEVICE_NOT_FOUND(84561, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TESTBED_DECORATOR_ADAPTER_DECORATOR_FAILURE(84562, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    REPORT_PARSER_READ_XML_FILE_ERROR(86901, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    REPORT_PARSER_XML_EVENT_READER_ERROR(86902, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    REPORT_MERGER_PARSE_REPORTS_TIMEOUT_ERROR(86951, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    REPORT_MERGER_PARSE_REPORTS_GENERIC_ERROR(86952, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    REPORT_MERGER_PARSE_MOBLY_REPORTS_TIMEOUT_ERROR(86953, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    REPORT_MERGER_PARSE_MOBLY_REPORTS_GENERIC_ERROR(86954, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    REPORT_MERGER_DIFF_DEVICE_BUILD_FINGERPRINT_FOUND(86955, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    REPORT_CREATOR_WRITE_REPORT_TO_XML_ERROR(87001, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBLY_REPORT_PARSER_PARSE_SUMMARY_FILE_ERROR(87051, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    TEST_RECORD_PARSE_PROTOS_TIMEOUT_ERROR(87101, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    TEST_RECORD_PARSE_PROTOS_GENERIC_ERROR(87102, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    TEST_RECORD_READ_PROTO_FILE_ERROR(87103, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    TEST_RECORD_WRITE_PROTO_FILE_ERROR(87104, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    TEST_RECORD_INVALID_PROTO_CONTEXT(87105, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MODULE_CONFIG_DEVICE_NUMBER_NOT_MATCH(87151, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MODULE_CONFIG_DRIVER_NOT_MATCH(87152, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MODULE_CONFIG_UNRECOGNIZED_OPTION_ERROR(87153, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TEST_SUITE_ROOT_DIR_NOT_EXIST(87201, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    TEST_SUITE_DEVICE_ABIS_MISSING(87202, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    TEST_SUITE_NO_ABIS_SUPPORTED(87203, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ABI_UTIL_GET_HOST_ABI_ERROR(87251, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    SUITE_MODULE_LOADER_DUPLICATED_FAMILY_MEMBERS(87301, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    COMMAND_HELPER_XTS_ROOT_DIR_NOT_EXIST(87351, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    COMMAND_HELPER_ANDROID_XTS_DIR_NOT_EXIST(87352, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    COMMAND_HELPER_UNEXPECTED_XTS_TYPE(87353, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ABSTRACT_XML_PARSER_PARSE_XML_ERROR(87401, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    PREV_RESULT_LOADER_SESSION_INDEX_OUT_OF_RANGE(87411, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    PREV_RESULT_LOADER_NO_PREVIOUS_SESSION_FOUND(87412, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    PREV_RESULT_LOADER_MISSING_TEST_RESULT_XML_FILE_IN_SESSION(87413, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    PREV_RESULT_LOADER_LOAD_TEST_RESULT_PROTO_FILE_ERROR(87414, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    PREV_RESULT_LOADER_LOAD_LEGACY_TEST_RESULT_XML_FILE_ERROR(87415, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    PREV_RESULT_LOADER_SESSION_RESULT_DIR_NOT_FOUND(87416, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    SUBPLAN_CREATOR_SUBPLAN_FILE_ALREADY_EXISTED(87441, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    SCREENSHOTS_METADATA_UTIL_GEN_METADATA_FILE_ERROR(87451, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    NO_OP_DECORATOR_TEST_FAILURE(91051, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    EXT_PLACE_HOLDER_TO_BE_RENAMED(100000, ErrorTypeProto.ErrorType.UNDETERMINED);

    public static final int MIN_CODE = 60001;
    public static final int MAX_CODE = 100000;
    private final int code;
    private final ErrorTypeProto.ErrorType type;

    private ExtErrorId(int code, ErrorTypeProto.ErrorType type) {
        Preconditions.checkArgument(code >= 60001);
        Preconditions.checkArgument(code <= 100000);
        Preconditions.checkArgument(type != ErrorTypeProto.ErrorType.UNCLASSIFIED);
        this.code = code;
        this.type = type;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public ErrorTypeProto.ErrorType type() {
        return this.type;
    }

    public String toString() {
        return ErrorIdFormatter.formatErrorId(this);
    }
}

