/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.metrics.stability.converter;

import com.google.common.collect.ImmutableSet;
import com.google.devtools.common.metrics.stability.converter.DeserializedErrorId;
import com.google.devtools.common.metrics.stability.model.ErrorId;
import com.google.devtools.common.metrics.stability.model.ErrorIdProvider;
import javax.annotation.Nullable;

public class DeserializedException
extends Exception
implements ErrorIdProvider<ErrorId> {
    private static final ImmutableSet<String> KNOWN_EXCEPTION_CLASS_NAMES = ImmutableSet.of("com.google.devtools.mobileharness.api.model.error.MobileHarnessException", DeserializedException.class.getName());
    private final DeserializedErrorId errorId;
    private final String originalExceptionClassName;
    private final String originalExceptionClassSimpleName;
    private final boolean displayClassSimpleName;

    DeserializedException(DeserializedErrorId errorId, String originalMessage, String originalExceptionClassName) {
        super(DeserializedException.formatMessage(originalMessage, DeserializedException.getClassSimpleName(originalExceptionClassName)));
        this.errorId = errorId;
        this.originalExceptionClassName = originalExceptionClassName;
        this.originalExceptionClassSimpleName = DeserializedException.getClassSimpleName(originalExceptionClassName);
        this.displayClassSimpleName = KNOWN_EXCEPTION_CLASS_NAMES.contains(originalExceptionClassName);
    }

    public String getOriginalExceptionClassName() {
        return this.originalExceptionClassName;
    }

    @Override
    public String toString() {
        String displayClassName = this.displayClassSimpleName ? this.originalExceptionClassSimpleName : this.originalExceptionClassName;
        String message = this.getLocalizedMessage();
        return message == null ? displayClassName : displayClassName + ": " + message;
    }

    @Override
    public ErrorId getErrorId() {
        return this.errorId;
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    @Override
    @Nullable
    public DeserializedException getCause() {
        return (DeserializedException)super.getCause();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return super.getStackTrace();
    }

    private static String formatMessage(String originalMessage, String originalExceptionClassSimpleName) {
        return String.format("%s [%s]", originalMessage, originalExceptionClassSimpleName);
    }

    private static String getClassSimpleName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }
}

