/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.rule;

import com.android.loganalysis.item.BugreportItem;
import com.android.loganalysis.rule.IRule;
import com.android.loganalysis.rule.InterruptRule;
import com.android.loganalysis.rule.LocationUsageRule;
import com.android.loganalysis.rule.ProcessUsageRule;
import com.android.loganalysis.rule.WakelockRule;
import com.android.loganalysis.rule.WifiStatsRule;
import java.util.Collection;
import java.util.LinkedList;
import org.json.JSONArray;

public class RuleEngine {
    BugreportItem mBugreportItem;
    private Collection<IRule> mRulesList;

    public RuleEngine(BugreportItem bugreportItem) {
        this.mBugreportItem = bugreportItem;
        this.mRulesList = new LinkedList<IRule>();
    }

    public void registerRules(RuleType ruleType) {
        if (ruleType == RuleType.ALL) {
            this.addPowerRules();
        } else if (ruleType == RuleType.POWER) {
            this.addPowerRules();
        }
    }

    public void executeRules() {
        for (IRule rule : this.mRulesList) {
            rule.applyRule();
        }
    }

    public JSONArray getAnalysis() {
        JSONArray result = new JSONArray();
        for (IRule rule : this.mRulesList) {
            result.put((Object)rule.getAnalysis());
        }
        return result;
    }

    private void addPowerRules() {
        this.mRulesList.add(new WakelockRule(this.mBugreportItem));
        this.mRulesList.add(new ProcessUsageRule(this.mBugreportItem));
        this.mRulesList.add(new LocationUsageRule(this.mBugreportItem));
        this.mRulesList.add(new WifiStatsRule(this.mBugreportItem));
        this.mRulesList.add(new InterruptRule(this.mBugreportItem));
    }

    public static enum RuleType {
        ALL,
        POWER;

    }
}

