/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.rule;

import com.android.loganalysis.item.BugreportItem;
import com.android.loganalysis.item.LocationDumpsItem;
import com.android.loganalysis.rule.AbstractPowerRule;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationUsageRule
extends AbstractPowerRule {
    private static final String LOCATION_USAGE_ANALYSIS = "LOCATION_USAGE_ANALYSIS";
    private static final float LOCATION_REQUEST_DURATION_THRESHOLD = 0.1f;
    private static final int LOCATION_INTERVAL_THRESHOLD = 285;
    private List<LocationDumpsItem.LocationInfoItem> mOffendingLocationRequestList;
    private BugreportItem mBugreportItem;

    public LocationUsageRule(BugreportItem bugreportItem) {
        super(bugreportItem);
        this.mBugreportItem = bugreportItem;
    }

    @Override
    public void applyRule() {
        this.mOffendingLocationRequestList = new ArrayList<LocationDumpsItem.LocationInfoItem>();
        if (this.mBugreportItem.getActivityService() == null || this.getTimeOnBattery() <= 0L) {
            return;
        }
        LocationDumpsItem locationDumpsItem = this.mBugreportItem.getActivityService().getLocationDumps();
        if (locationDumpsItem == null) {
            return;
        }
        long locationRequestThresholdMs = (long)((float)this.getTimeOnBattery() * 0.1f);
        for (LocationDumpsItem.LocationInfoItem locationClient : locationDumpsItem.getLocationClients()) {
            String priority = locationClient.getPriority();
            int effectiveIntervalSec = locationClient.getEffectiveInterval();
            if (effectiveIntervalSec >= 285 || priority.equals("PRIORITY_NO_POWER") || TimeUnit.MINUTES.toMillis(locationClient.getDuration()) <= locationRequestThresholdMs) continue;
            this.mOffendingLocationRequestList.add(locationClient);
        }
    }

    @Override
    public JSONObject getAnalysis() {
        JSONObject locationAnalysis = new JSONObject();
        StringBuilder analysis = new StringBuilder();
        if (this.mOffendingLocationRequestList == null || this.mOffendingLocationRequestList.size() <= 0) {
            analysis.append("No apps requested for frequent location updates. ");
        } else {
            for (LocationDumpsItem.LocationInfoItem locationClient : this.mOffendingLocationRequestList) {
                analysis.append(String.format("Package %s is requesting for location updates every %d secs with priority %s.", locationClient.getPackage(), locationClient.getEffectiveInterval(), locationClient.getPriority()));
            }
        }
        try {
            locationAnalysis.put(LOCATION_USAGE_ANALYSIS, (Object)analysis.toString().trim());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return locationAnalysis;
    }
}

