/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.rule;

import com.android.loganalysis.item.BugreportItem;
import com.android.loganalysis.item.InterruptItem;
import com.android.loganalysis.rule.AbstractPowerRule;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class InterruptRule
extends AbstractPowerRule {
    private static final String INTERRUPT_ANALYSIS = "INTERRUPT_ANALYSIS";
    private static final long INTERRUPT_THRESHOLD_MS = 120000L;
    private List<InterruptItem.InterruptInfoItem> mOffendingInterruptsList;

    public InterruptRule(BugreportItem bugreportItem) {
        super(bugreportItem);
    }

    @Override
    public void applyRule() {
        this.mOffendingInterruptsList = new ArrayList<InterruptItem.InterruptInfoItem>();
        InterruptItem interruptItem = this.getDetailedAnalysisItem().getInterruptItem();
        if (interruptItem == null || this.getTimeOnBattery() < 0L) {
            return;
        }
        for (InterruptItem.InterruptInfoItem interrupts : interruptItem.getInterrupts()) {
            long interruptsPerMs = this.getTimeOnBattery() / (long)interrupts.getInterruptCount();
            if (interruptsPerMs >= 120000L) continue;
            this.mOffendingInterruptsList.add(interrupts);
        }
    }

    @Override
    public JSONObject getAnalysis() {
        JSONObject interruptAnalysis = new JSONObject();
        StringBuilder analysis = new StringBuilder();
        if (this.mOffendingInterruptsList == null || this.mOffendingInterruptsList.size() <= 0) {
            analysis.append(String.format("No interrupts woke up device more frequent than %d secs.", TimeUnit.MILLISECONDS.toSeconds(120000L)));
        } else {
            for (InterruptItem.InterruptInfoItem interrupts : this.mOffendingInterruptsList) {
                if (interrupts.getCategory() != InterruptItem.InterruptCategory.UNKNOWN_INTERRUPT) {
                    analysis.append(String.format("Frequent interrupts from %s (%s). ", new Object[]{interrupts.getCategory(), interrupts.getName()}));
                    continue;
                }
                analysis.append(String.format("Frequent interrupts from %s. ", interrupts.getName()));
            }
        }
        try {
            interruptAnalysis.put(INTERRUPT_ANALYSIS, (Object)analysis.toString().trim());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return interruptAnalysis;
    }
}

