/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.WakelockItem;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.util.NumberFormattingUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WakelockParser
implements IParser {
    private static final String WAKE_LOCK_PAT_SUFFIX = "(?:(\\d+)d)?\\s?(?:(\\d+)h)?\\s?(?:(\\d+)m)?\\s?(?:(\\d+)s)?\\s?(?:(\\d+)ms)?\\s?\\((\\d+) times\\)(?: max=\\d+)? realtime";
    private static final Pattern KERNEL_WAKE_LOCK_PAT = Pattern.compile("^\\s*Kernel Wake lock (.+): (?:(\\d+)d)?\\s?(?:(\\d+)h)?\\s?(?:(\\d+)m)?\\s?(?:(\\d+)s)?\\s?(?:(\\d+)ms)?\\s?\\((\\d+) times\\)(?: max=\\d+)? realtime");
    private static final Pattern PARTIAL_WAKE_LOCK_PAT = Pattern.compile("^\\s*Wake lock (.*)\\s(.+): (?:(\\d+)d)?\\s?(?:(\\d+)h)?\\s?(?:(\\d+)m)?\\s?(?:(\\d+)s)?\\s?(?:(\\d+)ms)?\\s?\\((\\d+) times\\)(?: max=\\d+)? realtime");
    private WakelockItem mItem = new WakelockItem();
    public static final int TOP_WAKELOCK_COUNT = 5;

    @Override
    public WakelockItem parse(List<String> lines) {
        Matcher m = null;
        int wakelockCounter = 0;
        for (String line : lines) {
            if (wakelockCounter >= 5 || "".equals(line.trim())) break;
            m = KERNEL_WAKE_LOCK_PAT.matcher(line);
            if (m.matches() && !line.contains("PowerManagerService.WakeLocks")) {
                this.parseKernelWakeLock(line, WakelockItem.WakeLockCategory.KERNEL_WAKELOCK);
                ++wakelockCounter;
                continue;
            }
            m = PARTIAL_WAKE_LOCK_PAT.matcher(line);
            if (!m.matches()) continue;
            this.parsePartialWakeLock(line, WakelockItem.WakeLockCategory.PARTIAL_WAKELOCK);
            ++wakelockCounter;
        }
        return this.mItem;
    }

    void parseKernelWakeLock(String line, WakelockItem.WakeLockCategory category) {
        Matcher m = KERNEL_WAKE_LOCK_PAT.matcher(line);
        if (!m.matches()) {
            return;
        }
        String name = m.group(1);
        long wakelockTime = NumberFormattingUtil.getMs(NumberFormattingUtil.parseIntOrZero(m.group(2)), NumberFormattingUtil.parseIntOrZero(m.group(3)), NumberFormattingUtil.parseIntOrZero(m.group(4)), NumberFormattingUtil.parseIntOrZero(m.group(5)), NumberFormattingUtil.parseIntOrZero(m.group(6)));
        int timesCalled = Integer.parseInt(m.group(7));
        this.mItem.addWakeLock(name, wakelockTime, timesCalled, category);
    }

    void parsePartialWakeLock(String line, WakelockItem.WakeLockCategory category) {
        Matcher m = PARTIAL_WAKE_LOCK_PAT.matcher(line);
        if (!m.matches()) {
            return;
        }
        String processUID = m.group(1);
        String name = m.group(2);
        long wakelockTime = NumberFormattingUtil.getMs(NumberFormattingUtil.parseIntOrZero(m.group(3)), NumberFormattingUtil.parseIntOrZero(m.group(4)), NumberFormattingUtil.parseIntOrZero(m.group(5)), NumberFormattingUtil.parseIntOrZero(m.group(6)), NumberFormattingUtil.parseIntOrZero(m.group(7)));
        int timesCalled = Integer.parseInt(m.group(8));
        this.mItem.addWakeLock(name, processUID, wakelockTime, timesCalled, category);
    }

    WakelockItem getItem() {
        return this.mItem;
    }
}

