/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.TraceFormatItem;
import com.android.loganalysis.parser.IParser;
import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TraceFormatParser
implements IParser {
    private static final Pattern SPLIT_FORMAT_LINE = Pattern.compile(".*?\"(?<printf>.*?)\"(?<params>.*)");
    private static final Pattern SPLIT_PARAMS = Pattern.compile("->(?<param>\\w+)");
    private static final Pattern PRINTF_SPECIFIERS = Pattern.compile("(?<num>%(?:llu|lu|u|lld|ld|d|(?:.\\d*)?f))|(?<hex>%\\d*(?:x|X))|(?<str>%s)");
    static final String MATCH_NUM = "-?\\\\d+(?:\\\\.\\\\d+)?";
    static final String MATCH_HEX = "[\\\\da-fA-F]+";
    static final String MATCH_STR = "[\\\\w]*";

    @Override
    public TraceFormatItem parse(List<String> lines) {
        if (lines == null || lines.size() != 1) {
            throw new RuntimeException("Cannot parse format line: expect one-line trace format");
        }
        Matcher formatLineMatcher = SPLIT_FORMAT_LINE.matcher(lines.get(0));
        if (!formatLineMatcher.matches()) {
            throw new RuntimeException("Cannot parse format line: unexpected format");
        }
        String printfString = formatLineMatcher.group("printf");
        String paramsString = formatLineMatcher.group("params");
        ArrayList<String> allParams = new ArrayList<String>();
        ArrayList<String> numParams = new ArrayList<String>();
        ArrayList<String> hexParams = new ArrayList<String>();
        ArrayList<String> strParams = new ArrayList<String>();
        Matcher paramsMatcher = SPLIT_PARAMS.matcher(paramsString);
        while (paramsMatcher.find()) {
            String camelCasedParam = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, paramsMatcher.group("param"));
            allParams.add(camelCasedParam);
        }
        StringBuffer regexBuilder = new StringBuffer();
        int paramIndex = 0;
        Matcher printfMatcher = PRINTF_SPECIFIERS.matcher(printfString);
        while (printfMatcher.find()) {
            String currentParam = (String)allParams.get(paramIndex++);
            if (printfMatcher.group("num") != null) {
                printfMatcher.appendReplacement(regexBuilder, TraceFormatParser.createNamedRegexGroup(MATCH_NUM, currentParam));
                numParams.add(currentParam);
                continue;
            }
            if (printfMatcher.group("hex") != null) {
                printfMatcher.appendReplacement(regexBuilder, TraceFormatParser.createNamedRegexGroup(MATCH_HEX, currentParam));
                hexParams.add(currentParam);
                continue;
            }
            if (printfMatcher.group("str") != null) {
                printfMatcher.appendReplacement(regexBuilder, TraceFormatParser.createNamedRegexGroup(MATCH_STR, currentParam));
                strParams.add(currentParam);
                continue;
            }
            throw new RuntimeException("Unrecognized specifier: " + printfMatcher.group());
        }
        printfMatcher.appendTail(regexBuilder);
        Pattern generatedRegex = Pattern.compile(regexBuilder.toString());
        TraceFormatItem item = new TraceFormatItem();
        item.setRegex(generatedRegex);
        item.setParameters(allParams);
        item.setNumericParameters(numParams);
        item.setHexParameters(hexParams);
        item.setStringParameters(strParams);
        return item;
    }

    private static String createNamedRegexGroup(String base, String name) {
        return String.format("(?<%s>%s)", name, base);
    }
}

