/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.MemInfoItem;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.util.ArrayUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemInfoParser
implements IParser {
    private static final Pattern INFO_LINE = Pattern.compile("^([^:]+):\\s+(\\d+) kB");

    @Override
    public MemInfoItem parse(List<String> lines) {
        String text = ArrayUtil.join("\n", lines).trim();
        if ("".equals(text)) {
            return null;
        }
        MemInfoItem item = new MemInfoItem();
        item.setText(text);
        for (String line : lines) {
            Matcher m = INFO_LINE.matcher(line);
            if (!m.matches()) continue;
            String key = m.group(1);
            try {
                Long value = Long.parseLong(m.group(2));
                item.put(key, value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return item;
    }
}

