/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.GenericItem;
import com.android.loganalysis.item.IItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WakelockItem
implements IItem {
    public static final String WAKELOCKS = "WAKELOCKS_INFO";
    private Collection<WakelockInfoItem> mWakeLocks = new LinkedList<WakelockInfoItem>();

    public void addWakeLock(String name, String processUID, long heldTime, int timesCalled, WakeLockCategory category) {
        this.mWakeLocks.add(new WakelockInfoItem(name, processUID, heldTime, timesCalled, category));
    }

    public void addWakeLock(String name, long heldTime, int timesCalled, WakeLockCategory category) {
        this.addWakeLock(name, null, heldTime, timesCalled, category);
    }

    public List<WakelockInfoItem> getWakeLocks(WakeLockCategory category) {
        LinkedList<WakelockInfoItem> wakeLocks = new LinkedList<WakelockInfoItem>();
        if (category == null) {
            return wakeLocks;
        }
        for (WakelockInfoItem wakeLock : this.mWakeLocks) {
            if (!category.equals((Object)wakeLock.getCategory())) continue;
            wakeLocks.add(wakeLock);
        }
        return wakeLocks;
    }

    public List<WakelockInfoItem> getWakeLocks() {
        LinkedList<WakelockInfoItem> wakeLocks = new LinkedList<WakelockInfoItem>();
        for (WakelockInfoItem wakeLock : this.mWakeLocks) {
            wakeLocks.add(wakeLock);
        }
        return wakeLocks;
    }

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("Wakelock items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        if (this.mWakeLocks != null) {
            try {
                JSONArray wakeLocks = new JSONArray();
                for (WakelockInfoItem wakeLock : this.mWakeLocks) {
                    wakeLocks.put((Object)wakeLock.toJson());
                }
                object.put(WAKELOCKS, (Object)wakeLocks);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return object;
    }

    public static class WakelockInfoItem
    extends GenericItem {
        public static final String NAME = "NAME";
        public static final String PROCESS_UID = "PROCESS_UID";
        public static final String PROCESS_NAME = "PROCESS_NAME";
        public static final String HELD_TIME = "HELD_TIME";
        public static final String LOCKED_COUNT = "LOCKED_COUNT";
        public static final String CATEGORY = "CATEGORY";
        private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("NAME", "PROCESS_UID", "PROCESS_NAME", "HELD_TIME", "LOCKED_COUNT", "CATEGORY"));

        public WakelockInfoItem(String name, long heldTime, int lockedCount, WakeLockCategory category) {
            this(name, null, heldTime, lockedCount, category);
        }

        public WakelockInfoItem(String name, String processUID, long heldTime, int lockedCount, WakeLockCategory category) {
            super(ATTRIBUTES);
            this.setAttribute(NAME, name);
            this.setAttribute(PROCESS_UID, processUID);
            this.setAttribute(HELD_TIME, heldTime);
            this.setAttribute(LOCKED_COUNT, lockedCount);
            this.setAttribute(CATEGORY, (Object)category);
        }

        public String getName() {
            return (String)this.getAttribute(NAME);
        }

        public String getProcessUID() {
            return (String)this.getAttribute(PROCESS_UID);
        }

        public long getHeldTime() {
            return (Long)this.getAttribute(HELD_TIME);
        }

        public int getLockedCount() {
            return (Integer)this.getAttribute(LOCKED_COUNT);
        }

        public WakeLockCategory getCategory() {
            return (WakeLockCategory)((Object)this.getAttribute(CATEGORY));
        }

        public void setWakelockProcessName(String processName) {
            this.setAttribute(PROCESS_NAME, processName);
        }
    }

    public static enum WakeLockCategory {
        KERNEL_WAKELOCK,
        PARTIAL_WAKELOCK;

    }
}

