/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.GenericItem;
import com.android.loganalysis.item.IItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InterruptItem
implements IItem {
    public static final String INTERRUPTS = "INTERRUPT_INFO";
    private Collection<InterruptInfoItem> mInterrupts = new LinkedList<InterruptInfoItem>();

    public void addInterrupt(String name, int interruptCount, InterruptCategory category) {
        this.mInterrupts.add(new InterruptInfoItem(name, interruptCount, category));
    }

    public List<InterruptInfoItem> getInterrupts(InterruptCategory category) {
        LinkedList<InterruptInfoItem> interrupts = new LinkedList<InterruptInfoItem>();
        if (category == null) {
            return interrupts;
        }
        for (InterruptInfoItem interrupt : this.mInterrupts) {
            if (!category.equals((Object)interrupt.getCategory())) continue;
            interrupts.add(interrupt);
        }
        return interrupts;
    }

    public List<InterruptInfoItem> getInterrupts() {
        return (List)this.mInterrupts;
    }

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("Wakelock items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        if (this.mInterrupts != null) {
            try {
                JSONArray interrupts = new JSONArray();
                for (InterruptInfoItem interrupt : this.mInterrupts) {
                    interrupts.put((Object)interrupt.toJson());
                }
                object.put(INTERRUPTS, (Object)interrupts);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return object;
    }

    public static class InterruptInfoItem
    extends GenericItem {
        public static final String NAME = "NAME";
        public static final String CATEGORY = "CATEGORY";
        public static final String INTERRUPT_COUNT = "INTERRUPT_COUNT";
        private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("NAME", "INTERRUPT_COUNT", "CATEGORY"));

        public InterruptInfoItem(String name, int interruptCount, InterruptCategory category) {
            super(ATTRIBUTES);
            this.setAttribute(NAME, name);
            this.setAttribute(INTERRUPT_COUNT, interruptCount);
            this.setAttribute(CATEGORY, (Object)category);
        }

        public String getName() {
            return (String)this.getAttribute(NAME);
        }

        public int getInterruptCount() {
            return (Integer)this.getAttribute(INTERRUPT_COUNT);
        }

        public InterruptCategory getCategory() {
            return (InterruptCategory)((Object)this.getAttribute(CATEGORY));
        }
    }

    public static enum InterruptCategory {
        WIFI_INTERRUPT,
        MODEM_INTERRUPT,
        ALARM_INTERRUPT,
        ADSP_INTERRUPT,
        UNKNOWN_INTERRUPT;

    }
}

