/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.BatteryUsageItem;
import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.IItem;
import com.android.loganalysis.item.InterruptItem;
import com.android.loganalysis.item.ProcessUsageItem;
import com.android.loganalysis.item.WakelockItem;
import org.json.JSONException;
import org.json.JSONObject;

public class BatteryStatsDetailedInfoItem
implements IItem {
    public static final String TIME_ON_BATTERY = "TIME_ON_BATTERY";
    public static final String SCREEN_ON_TIME = "SCREEN_ON_TIME";
    public static final String BATTERY_USAGE = "BATTERY_USAGE";
    public static final String WAKELOCKS = "WAKELOCKS";
    public static final String INTERRUPTS = "INTERRUPTS";
    public static final String PROCESS_USAGE = "PROCESS_USAGE";
    private long mTimeOnBattery = 0L;
    private long mScreenOnTime = 0L;
    private BatteryUsageItem mBatteryUsageItem = null;
    private WakelockItem mWakelockItem = null;
    private InterruptItem mInterruptItem = null;
    private ProcessUsageItem mprocessUsageItem = null;

    public void setTimeOnBattery(long timeOnBattery) {
        this.mTimeOnBattery = timeOnBattery;
    }

    public void setScreenOnTime(long screenOnTime) {
        this.mScreenOnTime = screenOnTime;
    }

    public void setWakelockItem(WakelockItem wakelockItem) {
        this.mWakelockItem = wakelockItem;
    }

    public void setInterruptItem(InterruptItem interruptItem) {
        this.mInterruptItem = interruptItem;
    }

    public void setProcessUsageItem(ProcessUsageItem processUsageItem) {
        this.mprocessUsageItem = processUsageItem;
    }

    public void setBatteryUsageItem(BatteryUsageItem batteryUsageItem) {
        this.mBatteryUsageItem = batteryUsageItem;
    }

    public long getTimeOnBattery() {
        return this.mTimeOnBattery;
    }

    public long getScreenOnTime() {
        return this.mScreenOnTime;
    }

    public WakelockItem getWakelockItem() {
        return this.mWakelockItem;
    }

    public InterruptItem getInterruptItem() {
        return this.mInterruptItem;
    }

    public ProcessUsageItem getProcessUsageItem() {
        return this.mprocessUsageItem;
    }

    public BatteryUsageItem getBatteryUsageItem() {
        return this.mBatteryUsageItem;
    }

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("Dumpsys battery info items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    @Override
    public JSONObject toJson() {
        JSONObject batteryStatsComponent = new JSONObject();
        try {
            if (this.mTimeOnBattery > 0L) {
                batteryStatsComponent.put(TIME_ON_BATTERY, this.getTimeOnBattery());
            }
            if (this.mScreenOnTime > 0L) {
                batteryStatsComponent.put(SCREEN_ON_TIME, this.getScreenOnTime());
            }
            if (this.mBatteryUsageItem != null) {
                batteryStatsComponent.put(BATTERY_USAGE, (Object)this.mBatteryUsageItem.toJson());
            }
            if (this.mWakelockItem != null) {
                batteryStatsComponent.put(WAKELOCKS, (Object)this.mWakelockItem.toJson());
            }
            if (this.mInterruptItem != null) {
                batteryStatsComponent.put(INTERRUPTS, (Object)this.mInterruptItem.toJson());
            }
            if (this.mprocessUsageItem != null) {
                batteryStatsComponent.put(PROCESS_USAGE, (Object)this.mprocessUsageItem.toJson());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return batteryStatsComponent;
    }
}

