/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis;

import com.android.loganalysis.item.BugreportItem;
import com.android.loganalysis.item.DvmLockSampleItem;
import com.android.loganalysis.item.IItem;
import com.android.loganalysis.item.KernelLogItem;
import com.android.loganalysis.item.LogcatItem;
import com.android.loganalysis.item.MemoryHealthItem;
import com.android.loganalysis.parser.BugreportParser;
import com.android.loganalysis.parser.DvmLockSampleParser;
import com.android.loganalysis.parser.KernelLogParser;
import com.android.loganalysis.parser.LogcatParser;
import com.android.loganalysis.parser.MemoryHealthParser;
import com.android.loganalysis.rule.RuleEngine;
import com.android.loganalysis.util.config.ArgsOptionParser;
import com.android.loganalysis.util.config.ConfigurationException;
import com.android.loganalysis.util.config.Option;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LogAnalyzer {
    @Option(name="bugreport", description="The path to the bugreport")
    private String mBugreportPath = null;
    @Option(name="logcat", description="The path to the logcat")
    private String mLogcatPath = null;
    @Option(name="kernel-log", description="The path to the kernel log")
    private String mKernelLogPath = null;
    @Option(name="memory-health", description="The path to the memory health log")
    private String mMemoryHealthLogPath = null;
    @Option(name="output", description="The output format, currently only JSON")
    private OutputFormat mOutputFormat = OutputFormat.JSON;
    @Option(name="rule-type", description="The type of rules to be applied")
    private RuleEngine.RuleType mRuleType = RuleEngine.RuleType.ALL;
    @Option(name="print", description="Print the result type")
    private List<ResultType> mResultType = new ArrayList<ResultType>();
    @Option(name="events-log", description="The path to the events log")
    private String mEventsLogPath = null;
    private static final String RAW_DATA = "RAW";
    private static final String ANALYSIS_DATA = "ANALYSIS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run(String[] args) {
        BufferedReader reader;
        block17: {
            block16: {
                block15: {
                    block14: {
                        try {
                            this.initArgs(args);
                        }
                        catch (ConfigurationException e) {
                            this.printUsage();
                            return;
                        }
                        if (!this.checkPreconditions()) {
                            this.printUsage();
                            return;
                        }
                        reader = null;
                        if (this.mBugreportPath == null) break block14;
                        reader = this.getBufferedReader(this.mBugreportPath);
                        BugreportItem bugreport = new BugreportParser().parse(reader);
                        this.printBugreport(bugreport);
                        this.close(reader);
                        return;
                    }
                    if (this.mLogcatPath == null) break block15;
                    reader = this.getBufferedReader(this.mLogcatPath);
                    LogcatItem logcat = new LogcatParser().parse(reader);
                    this.printLogcat(logcat);
                    this.close(reader);
                    return;
                }
                if (this.mKernelLogPath == null) break block16;
                reader = this.getBufferedReader(this.mKernelLogPath);
                KernelLogItem kernelLog = new KernelLogParser().parse(reader);
                this.printKernelLog(kernelLog);
                this.close(reader);
                return;
            }
            if (this.mMemoryHealthLogPath == null) break block17;
            reader = this.getBufferedReader(this.mMemoryHealthLogPath);
            MemoryHealthItem item = new MemoryHealthParser().parse(reader);
            this.printMemoryHealthLog(item);
            this.close(reader);
            return;
        }
        try {
            if (this.mEventsLogPath != null) {
                reader = this.getBufferedReader(this.mEventsLogPath);
                DvmLockSampleItem item = new DvmLockSampleParser().parse(reader);
                this.printDVMLog(item);
                this.close(reader);
                return;
            }
            this.close(reader);
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
            this.close(reader);
        }
        catch (IOException e2) {
            System.err.println(e2.getMessage());
            this.close(reader);
            {
                catch (Throwable throwable) {
                    this.close(reader);
                    throw throwable;
                }
            }
        }
        this.printUsage();
    }

    private void printMemoryHealthLog(MemoryHealthItem item) {
        System.out.println(item.toJson().toString());
    }

    private void printBugreport(BugreportItem bugreport) {
        block11: {
            block13: {
                block12: {
                    if (!OutputFormat.JSON.equals((Object)this.mOutputFormat)) break block11;
                    if (this.mResultType.size() != 0) break block12;
                    this.printJson(bugreport);
                    break block11;
                }
                if (this.mResultType.size() != 1) break block13;
                switch (this.mResultType.get(0).ordinal()) {
                    case 0: {
                        this.printJson(bugreport);
                        break block11;
                    }
                    case 1: {
                        this.printBugreportAnalysis(this.getBugreportAnalysis(bugreport));
                        break block11;
                    }
                    default: {
                        return;
                    }
                }
            }
            JSONObject result = new JSONObject();
            try {
                for (ResultType resultType : this.mResultType) {
                    switch (resultType.ordinal()) {
                        case 0: {
                            result.put(RAW_DATA, (Object)bugreport.toJson());
                            break;
                        }
                        case 1: {
                            result.put(ANALYSIS_DATA, (Object)this.getBugreportAnalysis(bugreport));
                            break;
                        }
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.printJson(result);
        }
    }

    private JSONArray getBugreportAnalysis(BugreportItem bugreport) {
        RuleEngine ruleEngine = new RuleEngine(bugreport);
        ruleEngine.registerRules(this.mRuleType);
        ruleEngine.executeRules();
        if (ruleEngine.getAnalysis() != null) {
            return ruleEngine.getAnalysis();
        }
        return new JSONArray();
    }

    private void printBugreportAnalysis(JSONArray analysis) {
        if (analysis != null && analysis.length() > 0) {
            System.out.println(analysis.toString());
        } else {
            System.out.println(new JSONObject().toString());
        }
    }

    private void printLogcat(LogcatItem logcat) {
        if (OutputFormat.JSON.equals((Object)this.mOutputFormat)) {
            this.printJson(logcat);
        }
    }

    private void printKernelLog(KernelLogItem kernelLog) {
        if (OutputFormat.JSON.equals((Object)this.mOutputFormat)) {
            this.printJson(kernelLog);
        }
    }

    private void printDVMLog(DvmLockSampleItem dvmLog) {
        if (OutputFormat.JSON.equals((Object)this.mOutputFormat)) {
            this.printJson(dvmLog);
        }
    }

    private void printJson(IItem item) {
        if (item != null && item.toJson() != null) {
            this.printJson(item.toJson());
        } else {
            this.printJson(new JSONObject());
        }
    }

    private void printJson(JSONObject json) {
        if (json != null) {
            System.out.println(json.toString());
        } else {
            System.out.println(new JSONObject().toString());
        }
    }

    private BufferedReader getBufferedReader(String filepath) throws FileNotFoundException {
        return new BufferedReader(new FileReader(new File(filepath)));
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initArgs(String[] args) throws ConfigurationException {
        ArgsOptionParser opt = new ArgsOptionParser(this);
        opt.parse(args);
    }

    private boolean checkPreconditions() {
        int logCount = 0;
        if (this.mBugreportPath != null) {
            ++logCount;
        }
        if (this.mLogcatPath != null) {
            ++logCount;
        }
        if (this.mKernelLogPath != null) {
            ++logCount;
        }
        if (this.mMemoryHealthLogPath != null) {
            ++logCount;
        }
        return logCount == 1;
    }

    private void printUsage() {
        System.err.println("Usage: loganalysis [--bugreport FILE | --events-log FILE | --logcat FILE | --kernel-log FILE]");
    }

    public static void main(String[] args) {
        LogAnalyzer analyzer = new LogAnalyzer();
        analyzer.run(args);
    }

    private static enum OutputFormat {
        JSON;

    }

    private static enum ResultType {
        RAW,
        ANALYSIS;

    }
}

