/*
 * Decompiled with CFR 0.152.
 */
package com.android.json.stream;

import com.android.json.stream.JsonScope;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class JsonWriter
implements Closeable {
    protected final Writer mOut;
    protected final List<JsonScope> mStack = new ArrayList<JsonScope>();
    private String mIndent;
    protected String mSeparator;

    public JsonWriter(Writer out) {
        this.mStack.add(JsonScope.EMPTY_DOCUMENT);
        this.mSeparator = ":";
        if (out == null) {
            throw new NullPointerException("out == null");
        }
        this.mOut = out;
    }

    public void setIndent(String indent) {
        if (indent.isEmpty()) {
            this.mIndent = null;
            this.mSeparator = ":";
        } else {
            this.mIndent = indent;
            this.mSeparator = ": ";
        }
    }

    public JsonWriter beginArray() throws IOException {
        return this.open(JsonScope.EMPTY_ARRAY, "[");
    }

    public JsonWriter endArray() throws IOException {
        return this.close(JsonScope.EMPTY_ARRAY, JsonScope.NONEMPTY_ARRAY, "]");
    }

    public JsonWriter beginObject() throws IOException {
        return this.open(JsonScope.EMPTY_OBJECT, "{");
    }

    public JsonWriter endObject() throws IOException {
        return this.close(JsonScope.EMPTY_OBJECT, JsonScope.NONEMPTY_OBJECT, "}");
    }

    private JsonWriter open(JsonScope empty, String openBracket) throws IOException {
        this.beforeValue(true);
        this.mStack.add(empty);
        this.mOut.write(openBracket);
        return this;
    }

    private JsonWriter close(JsonScope empty, JsonScope nonempty, String closeBracket) throws IOException {
        JsonScope context = this.peek();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException("Nesting problem: " + this.mStack);
        }
        this.mStack.remove(this.mStack.size() - 1);
        if (context == nonempty) {
            this.newline();
        }
        this.mOut.write(closeBracket);
        return this;
    }

    protected JsonScope peek() {
        return this.mStack.get(this.mStack.size() - 1);
    }

    protected void replaceTop(JsonScope topOfStack) {
        this.mStack.set(this.mStack.size() - 1, topOfStack);
    }

    public JsonWriter name(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.beforeName();
        this.string(name);
        return this;
    }

    public JsonWriter value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.beforeValue(false);
        this.string(value);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        this.beforeValue(false);
        this.mOut.write("null");
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        this.beforeValue(false);
        this.mOut.write(value ? "true" : "false");
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.beforeValue(false);
        this.mOut.append(Double.toString(value));
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.beforeValue(false);
        this.mOut.write(Long.toString(value));
        return this;
    }

    public void flush() throws IOException {
        this.mOut.flush();
    }

    @Override
    public void close() throws IOException {
        this.mOut.close();
        if (this.peek() != JsonScope.NONEMPTY_DOCUMENT) {
            throw new IOException("Incomplete document");
        }
    }

    private void string(String value) throws IOException {
        this.mOut.write("\"");
        int length = value.length();
        block8: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    this.mOut.write(92);
                    this.mOut.write(c);
                    continue block8;
                }
                case '\t': {
                    this.mOut.write("\\t");
                    continue block8;
                }
                case '\b': {
                    this.mOut.write("\\b");
                    continue block8;
                }
                case '\n': {
                    this.mOut.write("\\n");
                    continue block8;
                }
                case '\r': {
                    this.mOut.write("\\r");
                    continue block8;
                }
                case '\f': {
                    this.mOut.write("\\f");
                    continue block8;
                }
                default: {
                    if (c <= '\u001f') {
                        this.mOut.write(String.format("\\u%04x", c));
                        continue block8;
                    }
                    this.mOut.write(c);
                }
            }
        }
        this.mOut.write("\"");
    }

    protected void newline() throws IOException {
        if (this.mIndent == null) {
            return;
        }
        this.mOut.write("\n");
        for (int i = 1; i < this.mStack.size(); ++i) {
            this.mOut.write(this.mIndent);
        }
    }

    protected void beforeName() throws IOException {
        JsonScope context = this.peek();
        if (context == JsonScope.NONEMPTY_OBJECT) {
            this.mOut.write(44);
        } else if (context != JsonScope.EMPTY_OBJECT) {
            throw new IllegalStateException("Nesting problem: " + this.mStack);
        }
        this.newline();
        this.replaceTop(JsonScope.DANGLING_NAME);
    }

    protected void beforeValue(boolean root) throws IOException {
        switch (this.peek()) {
            case EMPTY_DOCUMENT: {
                if (!root) {
                    throw new IllegalStateException("JSON must start with an array or an object.");
                }
                this.replaceTop(JsonScope.NONEMPTY_DOCUMENT);
                break;
            }
            case EMPTY_ARRAY: {
                this.replaceTop(JsonScope.NONEMPTY_ARRAY);
                this.newline();
                break;
            }
            case NONEMPTY_ARRAY: {
                this.mOut.append(',');
                this.newline();
                break;
            }
            case DANGLING_NAME: {
                this.mOut.append(this.mSeparator);
                this.replaceTop(JsonScope.NONEMPTY_OBJECT);
                break;
            }
            case NONEMPTY_DOCUMENT: {
                throw new IllegalStateException("JSON must have only one top-level value.");
            }
            default: {
                throw new IllegalStateException("Nesting problem: " + this.mStack);
            }
        }
    }
}

