/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.MultipartForm;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;

public class ResultUploader {
    private static final int RESULT_XML_BYTES = 512000;
    MultipartForm mMultipartForm;

    public ResultUploader(String serverUrl, String suiteName) {
        this.mMultipartForm = new MultipartForm(serverUrl).addFormValue("suite", suiteName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int uploadResult(File reportFile, String referenceUrl) throws IOException {
        try (FileInputStream input = new FileInputStream(reportFile);){
            byte[] data = ResultUploader.getBytes(input);
            this.mMultipartForm.addFormFile("resultXml", "test-result.xml.gz", data);
            if (referenceUrl != null && !referenceUrl.trim().isEmpty()) {
                this.mMultipartForm.addFormValue("referenceUrl", referenceUrl);
            }
            int n = this.mMultipartForm.submit();
            return n;
        }
    }

    private static byte[] getBytes(InputStream input) throws IOException {
        int count;
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(512000);
        GZIPOutputStream gzipOutput = new GZIPOutputStream(byteOutput);
        byte[] buffer = new byte[1024];
        while ((count = input.read(buffer)) > 0) {
            gzipOutput.write(buffer, 0, count);
        }
        gzipOutput.close();
        return byteOutput.toByteArray();
    }
}

