/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.ModuleResult;
import com.android.compatibility.common.util.RetryChecksumStatus;
import com.android.compatibility.common.util.TestStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LightInvocationResult
implements IInvocationResult {
    private long mTimestamp;
    private Map<String, String> mInvocationInfo;
    private Set<String> mSerials;
    private String mBuildFingerprint;
    private String mTestPlan;
    private String mCommandLineArgs;
    private int mNotExecuted;
    private int mModuleCompleteCount;
    private RetryChecksumStatus mRetryChecksumStatus;
    private File mRetryDirectory;
    private Set<String> mModuleIds;
    private Map<TestStatus, Integer> mResultCounts;

    public LightInvocationResult(IInvocationResult result) {
        this.mTimestamp = result.getStartTime();
        this.mInvocationInfo = new HashMap<String, String>(result.getInvocationInfo());
        this.mSerials = new HashSet<String>(result.getDeviceSerials());
        this.mBuildFingerprint = result.getBuildFingerprint();
        this.mTestPlan = result.getTestPlan();
        this.mCommandLineArgs = result.getCommandLineArgs();
        this.mNotExecuted = result.getNotExecuted();
        this.mModuleCompleteCount = result.getModuleCompleteCount();
        this.mRetryChecksumStatus = RetryChecksumStatus.NotRetry;
        this.mRetryDirectory = result.getRetryDirectory();
        this.mModuleIds = new HashSet<String>();
        for (IModuleResult module : result.getModules()) {
            this.mModuleIds.add(module.getId());
        }
        this.mResultCounts = new HashMap<TestStatus, Integer>();
        for (TestStatus status : TestStatus.values()) {
            this.mResultCounts.put(status, result.countResults(status));
        }
    }

    @Override
    public List<IModuleResult> getModules() {
        ArrayList<IModuleResult> modules = new ArrayList<IModuleResult>();
        for (String id : this.mModuleIds) {
            modules.add(new ModuleResult(id));
        }
        return modules;
    }

    @Override
    public int countResults(TestStatus result) {
        return this.mResultCounts.get((Object)result);
    }

    @Override
    public int getNotExecuted() {
        return this.mNotExecuted;
    }

    @Override
    public IModuleResult getOrCreateModule(String id) {
        this.mModuleIds.add(id);
        return new ModuleResult(id);
    }

    @Override
    public void mergeModuleResult(IModuleResult moduleResult) {
        this.mModuleIds.add(moduleResult.getId());
    }

    @Override
    public void addInvocationInfo(String key, String value) {
        this.mInvocationInfo.put(key, value);
    }

    @Override
    public Map<String, String> getInvocationInfo() {
        return this.mInvocationInfo;
    }

    @Override
    public void setStartTime(long time) {
        this.mTimestamp = time;
    }

    @Override
    public long getStartTime() {
        return this.mTimestamp;
    }

    @Override
    public void setTestPlan(String plan) {
        this.mTestPlan = plan;
    }

    @Override
    public String getTestPlan() {
        return this.mTestPlan;
    }

    @Override
    public void addDeviceSerial(String serial) {
        this.mSerials.add(serial);
    }

    @Override
    public Set<String> getDeviceSerials() {
        return this.mSerials;
    }

    @Override
    public void setCommandLineArgs(String commandLineArgs) {
        this.mCommandLineArgs = commandLineArgs;
    }

    @Override
    public String getCommandLineArgs() {
        return this.mCommandLineArgs;
    }

    @Override
    public void setBuildFingerprint(String buildFingerprint) {
        this.mBuildFingerprint = buildFingerprint;
    }

    @Override
    public String getBuildFingerprint() {
        return this.mBuildFingerprint;
    }

    @Override
    public int getModuleCompleteCount() {
        return this.mModuleCompleteCount;
    }

    @Override
    public RetryChecksumStatus getRetryChecksumStatus() {
        return this.mRetryChecksumStatus;
    }

    @Override
    public void setRetryChecksumStatus(RetryChecksumStatus retryStatus) {
        this.mRetryChecksumStatus = retryStatus;
    }

    @Override
    public File getRetryDirectory() {
        return this.mRetryDirectory;
    }

    @Override
    public void setRetryDirectory(File resultDir) {
        this.mRetryDirectory = resultDir;
    }
}

