/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.VersionCodes;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import java.lang.reflect.Field;

public class ApiLevelUtil {
    public static final String CODENAME = "ro.build.version.codename";

    public static boolean isBefore(ITestDevice device, int version) throws DeviceNotAvailableException {
        return device.getApiLevel() < version;
    }

    public static boolean isBefore(ITestDevice device, String version) throws DeviceNotAvailableException {
        return device.getApiLevel() < ApiLevelUtil.resolveVersionString(version);
    }

    public static boolean isAfter(ITestDevice device, int version) throws DeviceNotAvailableException {
        return device.getApiLevel() > version;
    }

    public static boolean isAfter(ITestDevice device, String version) throws DeviceNotAvailableException {
        return device.getApiLevel() > ApiLevelUtil.resolveVersionString(version);
    }

    public static boolean isAtLeast(ITestDevice device, int version) throws DeviceNotAvailableException {
        return device.getApiLevel() >= version;
    }

    public static boolean isAtLeast(ITestDevice device, String version) throws DeviceNotAvailableException {
        return device.getApiLevel() >= ApiLevelUtil.resolveVersionString(version);
    }

    public static boolean isAtMost(ITestDevice device, int version) throws DeviceNotAvailableException {
        return device.getApiLevel() <= version;
    }

    public static boolean isAtMost(ITestDevice device, String version) throws DeviceNotAvailableException {
        return device.getApiLevel() <= ApiLevelUtil.resolveVersionString(version);
    }

    public static int getApiLevel(ITestDevice device) throws DeviceNotAvailableException {
        return device.getApiLevel();
    }

    public static boolean codenameEquals(ITestDevice device, String name) throws DeviceNotAvailableException {
        return device.getProperty(CODENAME).equalsIgnoreCase(name.trim());
    }

    public static boolean codenameStartsWith(ITestDevice device, String prefix) throws DeviceNotAvailableException {
        return device.getProperty(CODENAME).startsWith(prefix);
    }

    public static String getCodename(ITestDevice device) throws DeviceNotAvailableException {
        return device.getProperty(CODENAME);
    }

    protected static int resolveVersionString(String versionString) {
        try {
            return Integer.parseInt(versionString);
        }
        catch (NumberFormatException e1) {
            try {
                Field versionField = VersionCodes.class.getField(versionString.toUpperCase());
                return versionField.getInt(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e2) {
                throw new RuntimeException(String.format("Failed to parse version string %s", versionString), e2);
            }
        }
    }
}

