/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.version;

import com.google.common.base.Suppliers;
import com.google.common.flogger.FluentLogger;
import com.google.common.io.CharStreams;
import com.google.devtools.mobileharness.shared.util.base.ProtoTextFormat;
import com.google.devtools.mobileharness.shared.version.proto.VersionProto;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Supplier;

public class VersionUtil {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String BUILD_VERSION_RESOURCE_FILE_PATH = "/deviceinfra_build_version.textproto";
    private static final Supplier<Optional<VersionProto.BuildVersion>> BUILD_VERSION_SUPPLIER = Suppliers.memoize(VersionUtil::doGetBuildVersion);

    public static Optional<VersionProto.BuildVersion> getBuildVersion() {
        return BUILD_VERSION_SUPPLIER.get();
    }

    private static Optional<VersionProto.BuildVersion> doGetBuildVersion() {
        return VersionUtil.readResource(BUILD_VERSION_RESOURCE_FILE_PATH).flatMap(textproto -> {
            try {
                return Optional.of(ProtoTextFormat.parse(textproto, VersionProto.BuildVersion.class));
            }
            catch (TextFormat.ParseException e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(e)).log("Failed to parse BuildVersion textproto [%s]", textproto);
                return Optional.empty();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> readResource(String resourcePath) {
        try (InputStream inputStream = VersionUtil.class.getResourceAsStream(resourcePath);){
            if (inputStream == null) {
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            Optional<String> optional = Optional.of(CharStreams.toString(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).trim());
            return optional;
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(e)).log("Failed to read resource [%s]", resourcePath);
            return Optional.empty();
        }
    }

    private VersionUtil() {
    }
}

