/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.time;

import com.google.common.math.LongMath;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class TimeUtils {
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yy/MM/dd HH:mm:ss:SSS z");
    private static final DateTimeFormatter SHORT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss:SSS z");

    public static boolean isDurationPositive(java.time.Duration duration) {
        return !duration.isNegative() && !duration.isZero();
    }

    public static String toDateShortString(Instant instant) {
        return instant.atZone(ZoneOffset.UTC).format(SHORT_DATE_TIME_FORMATTER);
    }

    public static String toDateString(Instant instant) {
        return instant.atZone(ZoneOffset.UTC).format(DATE_TIME_FORMATTER);
    }

    public static java.time.Duration toJavaDuration(Duration protoDuration) {
        protoDuration = TimeUtils.normalizedDuration(protoDuration.getSeconds(), protoDuration.getNanos());
        return java.time.Duration.ofSeconds(protoDuration.getSeconds(), protoDuration.getNanos());
    }

    public static Instant toJavaInstant(Timestamp protoTimestamp) {
        protoTimestamp = TimeUtils.normalizedTimestamp(protoTimestamp.getSeconds(), protoTimestamp.getNanos());
        return Instant.ofEpochSecond(protoTimestamp.getSeconds(), protoTimestamp.getNanos());
    }

    public static Duration toProtoDuration(java.time.Duration duration) {
        return TimeUtils.normalizedDuration(duration.getSeconds(), duration.getNano());
    }

    public static Timestamp toProtoTimestamp(Instant instant) {
        return TimeUtils.normalizedTimestamp(instant.getEpochSecond(), instant.getNano());
    }

    public static String toReadableDurationString(java.time.Duration duration) {
        if (duration.compareTo(java.time.Duration.ofSeconds(1L)) < 0) {
            return String.format("%d ms", duration.toMillis());
        }
        StringBuilder result = new StringBuilder();
        long secondsPart = duration.toSecondsPart();
        long minutesPart = duration.toMinutesPart();
        long hours = duration.toHours();
        if (hours > 0L) {
            result.append(hours);
            result.append("h ");
        }
        if (minutesPart > 0L) {
            result.append(minutesPart);
            result.append("m ");
        }
        result.append(secondsPart);
        result.append("s");
        return result.toString();
    }

    private static Duration normalizedDuration(long seconds, int nanos) {
        if (nanos <= -1000000000 || nanos >= 1000000000) {
            seconds = LongMath.checkedAdd(seconds, nanos / 1000000000);
            nanos %= 1000000000;
        }
        if (seconds > 0L && nanos < 0) {
            nanos += 1000000000;
            --seconds;
        }
        if (seconds < 0L && nanos > 0) {
            nanos -= 1000000000;
            ++seconds;
        }
        Duration duration = Duration.newBuilder().setSeconds(seconds).setNanos(nanos).build();
        return Durations.checkValid(duration);
    }

    private static Timestamp normalizedTimestamp(long seconds, int nanos) {
        if (nanos <= -1000000000 || nanos >= 1000000000) {
            seconds = LongMath.checkedAdd(seconds, nanos / 1000000000);
            nanos %= 1000000000;
        }
        if (nanos < 0) {
            nanos += 1000000000;
            seconds = LongMath.checkedSubtract(seconds, 1L);
        }
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
        return Timestamps.checkValid(timestamp);
    }

    public static double toSecondsAsDouble(java.time.Duration duration) {
        return (double)duration.getSeconds() + (double)duration.getNano() / 1.0E9;
    }

    private TimeUtils() {
    }
}

