/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.time;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.devtools.mobileharness.shared.util.time.Sleeper;
import java.time.Duration;

final class Sleepers {
    private Sleepers() {
    }

    static enum NoOpSleeper implements Sleeper
    {
        INSTANCE;


        @Override
        public void sleep(Duration duration) throws InterruptedException {
            Preconditions.checkArgument(!duration.isNegative(), "duration (%s) must not be negative", (Object)duration);
        }

        public String toString() {
            return "Sleeper.noOpSleeper()";
        }
    }

    static enum DefaultSleeper implements Sleeper
    {
        INSTANCE;


        @Override
        public void sleep(Duration duration) throws InterruptedException {
            Preconditions.checkArgument(!duration.isNegative(), "duration (%s) must not be negative", (Object)duration);
            try {
                long millis = duration.toMillis();
                Duration nanosOnly = duration.minusMillis(millis);
                Verify.verify(nanosOnly.getSeconds() == 0L);
                int nanos = nanosOnly.getNano();
                Thread.sleep(millis, nanos);
            }
            catch (ArithmeticException tooBig) {
                Thread.sleep(Long.MAX_VALUE);
            }
        }

        public String toString() {
            return "Sleeper.defaultSleeper()";
        }
    }
}

