/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.reflection;

import com.google.devtools.mobileharness.api.model.error.BasicErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;

public class ReflectionUtil {
    public <T> Class<? extends T> loadClass(String className, Class<T> type, ClassLoader classLoader) throws MobileHarnessException, ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = Class.forName(className, true, classLoader);
        }
        catch (RuntimeException e) {
            throw new MobileHarnessException(BasicErrorId.REFLECTION_CLASS_LOAD_ERROR, "Failed to load class: " + className, e);
        }
        if (type.isAssignableFrom(clazz)) {
            return clazz;
        }
        throw new MobileHarnessException(BasicErrorId.REFLECTION_CLASS_TYPE_NOT_MATCHED, String.format("%s is not assignable from %s", type.getName(), clazz.getName()));
    }
}

