/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.network;

import com.google.devtools.mobileharness.api.model.error.BasicErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class NetworkUtil {
    public String getLocalHostName() throws MobileHarnessException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new MobileHarnessException(BasicErrorId.LOCAL_NETWORK_HOSTNAME_DETECTION_ERROR, "Failed to detect host name.", e);
        }
    }

    public List<InetAddress> getInetAddresses() throws MobileHarnessException {
        return this.getInetAddresses(null);
    }

    public List<InetAddress> getInetAddresses(@Nullable Predicate<InetAddress> inetAddressFilter) throws MobileHarnessException {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLinkLocalAddress() || addr.isLoopbackAddress() || inetAddressFilter != null && !inetAddressFilter.test(addr)) continue;
                    result.add(addr);
                }
            }
        }
        catch (SocketException e) {
            throw new MobileHarnessException(BasicErrorId.LOCAL_NETWORK_INTERFACE_DETECTION_ERROR, "Failed to detect server network interface.", e);
        }
        return result;
    }
}

