/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.logging;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.mobileharness.shared.context.InvocationContext;
import com.google.devtools.mobileharness.shared.util.command.linecallback.CommandOutputLogger;
import com.google.devtools.mobileharness.shared.util.flags.Flags;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import javax.annotation.Nullable;

public final class MobileHarnessLogFormatter {
    private static final ImmutableSet<String> DIRECT_MODE_SOURCE_CLASS_NAMES = ImmutableSet.of(CommandOutputLogger.class.getName());
    private static final ZoneId ZONE_ID = ZoneId.of("America/Los_Angeles");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss:SSS z").withZone(ZONE_ID);
    private static final DateTimeFormatter SIMPLIFIED_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("MM-dd HH:mm:ss z").withZone(ZONE_ID);
    private static final Formatter FORMATTER = new DefaultFormatter(false);
    private static final Formatter SIMPLIFIED_FORMATTER = new DefaultFormatter(true);

    public static DateTimeFormatter getDateTimeFormatter() {
        return DATE_TIME_FORMATTER;
    }

    public static Formatter getDefaultFormatter() {
        return Flags.instance().simplifiedLogFormat.getNonNull() != false ? SIMPLIFIED_FORMATTER : FORMATTER;
    }

    private static String printThrowable(@Nullable Throwable e) {
        return e == null ? "" : Throwables.getStackTraceAsString(e);
    }

    private MobileHarnessLogFormatter() {
    }

    private static class DefaultFormatter
    extends Formatter {
        private final boolean simplified;

        private DefaultFormatter(boolean simplified) {
            this.simplified = simplified;
        }

        @Override
        public String format(LogRecord logRecord) {
            if (DIRECT_MODE_SOURCE_CLASS_NAMES.contains(logRecord.getSourceClassName())) {
                return String.format("%s\n%s", logRecord.getMessage(), MobileHarnessLogFormatter.printThrowable(logRecord.getThrown()));
            }
            if (this.simplified) {
                return String.format("%s %s/%s: %s%s\n%s", SIMPLIFIED_DATE_TIME_FORMATTER.format(logRecord.getInstant()), Character.valueOf(logRecord.getLevel().toString().charAt(0)), DefaultFormatter.getLoggerSimpleName(logRecord.getLoggerName()), logRecord.getMessage(), DefaultFormatter.getContext(), MobileHarnessLogFormatter.printThrowable(logRecord.getThrown()));
            }
            return String.format("%s %s %s [%s] %s%s\n%s", DATE_TIME_FORMATTER.format(logRecord.getInstant()), Character.valueOf(logRecord.getLevel().toString().charAt(0)), logRecord.getLoggerName(), logRecord.getSourceMethodName(), logRecord.getMessage(), DefaultFormatter.getContext(), MobileHarnessLogFormatter.printThrowable(logRecord.getThrown()));
        }

        private static String getLoggerSimpleName(@Nullable String loggerName) {
            String name = Strings.nullToEmpty(loggerName);
            return name.substring(name.lastIndexOf(46) + 1);
        }

        private static String getContext() {
            Map<InvocationContext.InvocationType, InvocationContext.InvocationInfo> context = InvocationContext.getCurrentContext();
            return context.isEmpty() ? "" : " " + String.valueOf(context);
        }
    }
}

