/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.flags;

import com.beust.jcommander.IStringConverter;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class Flag<T> {
    private static final Splitter ENTRY_SPLITTER = Splitter.on(',');
    @Nullable
    private final T value;

    static Flag<List<String>> stringList(String ... defaultValues) {
        return Flag.value(ImmutableList.copyOf(defaultValues));
    }

    static <T> Flag<T> value(@Nullable T defaultValue) {
        return new Flag<T>(defaultValue);
    }

    Flag(@Nullable T value) {
        this.value = value;
    }

    @Nullable
    public T get() {
        return this.value;
    }

    public T getNonNull() {
        return Objects.requireNonNull(this.get());
    }

    public static class StringMapConverter
    implements IStringConverter<Flag<Map<String, String>>> {
        @Override
        public Flag<Map<String, String>> convert(String value) {
            if (value.isEmpty()) {
                return Flag.value(ImmutableMap.of());
            }
            ImmutableMap.Builder<String, String> result = ImmutableMap.builder();
            for (String s2 : ENTRY_SPLITTER.split(value)) {
                int index = s2.indexOf(61);
                if (index == -1) {
                    throw new IllegalArgumentException("Invalid map entry syntax " + s2);
                }
                result.put(s2.substring(0, index).trim(), s2.substring(index + 1).trim());
            }
            return Flag.value(result.buildKeepingLast());
        }
    }

    public static class StringListConverter
    implements IStringConverter<Flag<List<String>>> {
        @Override
        public Flag<List<String>> convert(String value) {
            if (value.isEmpty()) {
                return Flag.value(ImmutableList.of());
            }
            return Flag.value(ImmutableList.copyOf(ENTRY_SPLITTER.split(value)));
        }
    }

    public static class StringConverter
    implements IStringConverter<Flag<String>> {
        @Override
        public Flag<String> convert(String value) {
            return Flag.value(value);
        }
    }

    public static class LongConverter
    implements IStringConverter<Flag<Long>> {
        @Override
        public Flag<Long> convert(String value) {
            return Flag.value(Long.parseLong(value));
        }
    }

    public static class IntegerConverter
    implements IStringConverter<Flag<Integer>> {
        @Override
        public Flag<Integer> convert(String value) {
            return Flag.value(Integer.parseInt(value));
        }
    }

    public static class BooleanConverter
    implements IStringConverter<Flag<Boolean>> {
        @Override
        public Flag<Boolean> convert(String value) {
            return Flag.value(Boolean.parseBoolean(value));
        }
    }
}

