/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command.history;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.shared.util.command.CommandResult;
import com.google.devtools.mobileharness.shared.util.command.history.AutoValue_CommandRecord;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@AutoValue
public abstract class CommandRecord {
    static CommandRecord create(List<String> command) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int startPosition = Math.min(2, stackTrace.length);
        int endPosition = Math.min(startPosition + 3, stackTrace.length);
        return new AutoValue_CommandRecord(UUID.randomUUID().toString(), ImmutableList.copyOf(command), ImmutableList.copyOf(Arrays.asList(stackTrace).subList(startPosition, endPosition)), Thread.currentThread().getName(), Instant.now(), Optional.empty(), Optional.empty());
    }

    CommandRecord withResult(CommandResult result) {
        return new AutoValue_CommandRecord(this.id(), this.command(), this.stackTrace(), this.threadName(), this.startTime(), Optional.of(result), Optional.of(Instant.now()));
    }

    public abstract String id();

    public abstract ImmutableList<String> command();

    public abstract ImmutableList<StackTraceElement> stackTrace();

    public abstract String threadName();

    public abstract Instant startTime();

    public abstract Optional<CommandResult> result();

    public abstract Optional<Instant> endTime();
}

