/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command.history;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.shared.util.command.CommandResult;
import com.google.devtools.mobileharness.shared.util.command.CommandResults;
import com.google.devtools.mobileharness.shared.util.command.history.CommandRecord;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;

public class CommandHistory {
    private static final int DEFAULT_CAPACITY = 100000;
    private static final CommandHistory INSTANCE = new CommandHistory(100000);
    private final Lock recordLock = new ReentrantLock();
    @GuardedBy(value="recordLock")
    private final Map<String, CommandRecord> records;

    public static CommandHistory getInstance() {
        return INSTANCE;
    }

    @VisibleForTesting
    CommandHistory(int capacity) {
        this.records = new RecordCache(capacity);
    }

    public List<CommandRecord> getAllCommands() {
        this.recordLock.lock();
        try {
            ImmutableList<CommandRecord> immutableList = ImmutableList.copyOf(this.records.values());
            return immutableList;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    public List<CommandRecord> searchCommands(Predicate<CommandRecord> commandRecordFilter) {
        return this.getAllCommands().stream().filter(commandRecordFilter).collect(Collectors.toList());
    }

    @CanIgnoreReturnValue
    CommandRecord addCommand(List<String> command) {
        CommandRecord record = CommandRecord.create(command);
        this.recordLock.lock();
        try {
            this.records.put(record.id(), record);
        }
        finally {
            this.recordLock.unlock();
        }
        return record;
    }

    void addCommandResult(CommandRecord commandRecord, CommandResult result) {
        this.recordLock.lock();
        try {
            this.records.computeIfPresent(commandRecord.id(), (recordId, record) -> record.withResult(CommandResults.withoutOutput(result)));
        }
        finally {
            this.recordLock.unlock();
        }
    }

    private static class RecordCache
    extends LinkedHashMap<String, CommandRecord> {
        private final int capacity;

        private RecordCache(int capacity) {
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CommandRecord> eldest) {
            return this.size() > this.capacity;
        }
    }
}

