/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command.backend;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.devtools.mobileharness.shared.util.command.backend.AtomicResult;
import com.google.devtools.mobileharness.shared.util.command.backend.CapturingOutputStream;
import com.google.devtools.mobileharness.shared.util.command.backend.Command;
import com.google.devtools.mobileharness.shared.util.command.backend.CommandFailureException;
import com.google.devtools.mobileharness.shared.util.command.backend.CommandResult;
import com.google.devtools.mobileharness.shared.util.command.backend.ForwardingOutputStream;
import com.google.devtools.mobileharness.shared.util.command.backend.InputSource;
import com.google.devtools.mobileharness.shared.util.command.backend.Opener;
import com.google.devtools.mobileharness.shared.util.command.backend.OutputSink;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public abstract class CommandProcess {
    private final Command command;
    private final AtomicResult result;
    private final Opener<InputStream> stdinSourceOpener;
    private final Opener<OutputStream> stdoutSinkOpener;
    private final Opener<OutputStream> stderrSinkOpener;
    private final CapturingOutputStream stdoutStream = new CapturingOutputStream();
    private final CapturingOutputStream stderrStream = new CapturingOutputStream();

    protected CommandProcess(Command command) {
        this.command = Preconditions.checkNotNull(command);
        this.result = new AtomicResult(command, this::killHook);
        this.stdinSourceOpener = new Opener<InputStream>(command.stdinSource()::openStream);
        this.stdoutSinkOpener = new Opener<OutputStream>(() -> {
            switch (command.stdoutSink().kind()) {
                case PROCESS_OUT: {
                    return this.stdoutStream;
                }
                case PROCESS_ERR: {
                    return this.stderrStream;
                }
            }
            return command.stdoutSink().openStream();
        });
        this.stderrSinkOpener = new Opener<OutputStream>(() -> {
            switch (command.stderrSink().kind()) {
                case PROCESS_OUT: {
                    return this.stdoutStream;
                }
                case PROCESS_ERR: {
                    return this.stderrStream;
                }
            }
            return command.stderrSink().openStream();
        });
    }

    public final Command command() {
        return this.command;
    }

    public ListenableFuture<CommandResult> asFuture() {
        return this.result.future();
    }

    public final boolean isAlive() {
        return !this.result.isComplete();
    }

    @CanIgnoreReturnValue
    public final CommandResult await() throws CommandFailureException, InterruptedException {
        return this.result.await();
    }

    @CanIgnoreReturnValue
    public final CommandResult await(Duration timeout) throws CommandFailureException, InterruptedException, TimeoutException {
        return this.result.await(timeout);
    }

    @CanIgnoreReturnValue
    public final CommandResult awaitUninterruptibly() throws CommandFailureException {
        boolean interrupted = false;
        while (true) {
            try {
                CommandResult commandResult = this.await();
                return commandResult;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @CanIgnoreReturnValue
    public final <E extends Exception> CommandResult awaitChecked(Function<Exception, E> factory) throws E {
        try {
            return this.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (Exception)factory.apply(e);
        }
        catch (CommandFailureException e) {
            throw (Exception)factory.apply(e);
        }
    }

    public final CommandResult getDone() throws CommandFailureException {
        Optional<CommandResult> res = this.result.get();
        Preconditions.checkState(res.isPresent(), "Process %s is still alive - use await() to wait for the process to complete.", (Object)this);
        return res.get();
    }

    @CanIgnoreReturnValue
    public final CommandProcess kill() {
        this.killHook();
        return this;
    }

    @CanIgnoreReturnValue
    public final CommandProcess killForcibly() {
        this.killForciblyHook();
        return this;
    }

    public final OutputStream stdinStream() {
        return new ForwardingOutputStream(this.maybeGetStdinStream()){};
    }

    public final Writer stdinWriter(Charset cs) {
        return new OutputStreamWriter(this.maybeGetStdinStream(), cs);
    }

    public final Writer stdinWriterUtf8() {
        return this.stdinWriter(StandardCharsets.UTF_8);
    }

    public final InputStream stdoutStream() {
        return this.maybeGetStdoutStream().openInputStream();
    }

    public final InputStream stderrStream() {
        return this.maybeGetStderrStream().openInputStream();
    }

    public final Reader stdoutReader(Charset cs) {
        return new InputStreamReader(this.stdoutStream(), cs);
    }

    public final Reader stderrReader(Charset cs) {
        return new InputStreamReader(this.stderrStream(), cs);
    }

    public final Reader stdoutReaderUtf8() {
        return this.stdoutReader(StandardCharsets.UTF_8);
    }

    public final Reader stderrReaderUtf8() {
        return this.stderrReader(StandardCharsets.UTF_8);
    }

    private OutputStream maybeGetStdinStream() {
        Preconditions.checkState(this.command.stdinSource().kind().equals((Object)InputSource.Kind.PROCESS), "The process is reading stdin from %s, there is no stdin stream", (Object)this.command.stdinSource());
        return this.stdinStreamHook();
    }

    private CapturingOutputStream maybeGetStdoutStream() {
        Preconditions.checkState(this.command.stdoutSink().kind().equals((Object)OutputSink.Kind.PROCESS_OUT) || this.command.stderrSink().kind().equals((Object)OutputSink.Kind.PROCESS_OUT), "The process is writing stdout to %s and stderr to %s, there is no stdout stream", (Object)this.command.stdoutSink(), (Object)this.command.stderrSink());
        return this.stdoutStream;
    }

    private CapturingOutputStream maybeGetStderrStream() {
        Preconditions.checkState(this.command.stdoutSink().kind().equals((Object)OutputSink.Kind.PROCESS_ERR) || this.command.stderrSink().kind().equals((Object)OutputSink.Kind.PROCESS_ERR), "The process is writing stdout to %s and stderr to %s, there is no stderr stream", (Object)this.command.stdoutSink(), (Object)this.command.stderrSink());
        return this.stderrStream;
    }

    public final long processId() {
        return this.processIdHook();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final String toString() {
        return MoreObjects.toStringHelper(this).add("command", this.command).add("alive", this.isAlive()).toString();
    }

    protected final void notifyComplete(int exitCode) {
        this.result.complete(new CommandResult(exitCode, this.stdoutStream, this.stderrStream));
    }

    protected final InputStream openStdinSourceStream() throws IOException {
        Verify.verify(!this.command.stdinSource().kind().equals((Object)InputSource.Kind.PROCESS), "openStdinSourceStream() must never be called by a subclass implementation when the inputsource is the process itself.", new Object[0]);
        return this.stdinSourceOpener.open();
    }

    protected final OutputStream openStdoutSinkStream() throws IOException {
        return this.stdoutSinkOpener.open();
    }

    protected final OutputStream openStderrSinkStream() throws IOException {
        return this.stderrSinkOpener.open();
    }

    protected abstract void killHook();

    protected abstract void killForciblyHook();

    protected abstract long processIdHook();

    protected abstract OutputStream stdinStreamHook();
}

