/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.devtools.mobileharness.shared.util.command.Command;
import com.google.devtools.mobileharness.shared.util.command.CommandException;
import com.google.devtools.mobileharness.shared.util.command.CommandExecutionException;
import com.google.devtools.mobileharness.shared.util.command.CommandExecutor;
import com.google.devtools.mobileharness.shared.util.command.CommandFailureException;
import com.google.devtools.mobileharness.shared.util.command.CommandResult;
import com.google.devtools.mobileharness.shared.util.command.CommandResults;
import com.google.devtools.mobileharness.shared.util.command.CommandTimeoutException;
import com.google.devtools.mobileharness.shared.util.command.io.LineCollector;
import java.io.OutputStream;
import java.io.Writer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class CommandProcess {
    private static final CommandExecutor EXECUTOR = new CommandExecutor();
    private final Command command;
    private final com.google.devtools.mobileharness.shared.util.command.backend.CommandProcess backendProcess;
    private final LineCollector stdoutCollector;
    private final LineCollector stderrCollector;
    private final Duration finalizedTimeout;
    @Nullable
    private final Duration finalizedStartTimeout;
    private final OutputStream stdinStream;
    private final Writer stdinWriter;
    private final AtomicBoolean isTimeout = new AtomicBoolean();
    private final AtomicBoolean isStopped = new AtomicBoolean();
    private final SettableFuture<Boolean> successfulStartFuture = SettableFuture.create();

    CommandProcess(Command command, com.google.devtools.mobileharness.shared.util.command.backend.CommandProcess backendProcess, LineCollector stdoutCollector, LineCollector stderrCollector, Duration finalizedTimeout, @Nullable Duration finalizedStartTimeout) {
        this.command = command;
        this.backendProcess = backendProcess;
        this.stdoutCollector = stdoutCollector;
        this.stderrCollector = stderrCollector;
        this.finalizedTimeout = finalizedTimeout;
        this.finalizedStartTimeout = finalizedStartTimeout;
        this.stdinStream = backendProcess.stdinStream();
        this.stdinWriter = backendProcess.stdinWriterUtf8();
    }

    public CommandResult await() throws CommandFailureException, InterruptedException, CommandTimeoutException {
        try {
            int exitCode = this.backendProcess.await().exitCode();
            String stdout = this.stdoutCollector.waitForAllLines();
            String stderr = this.stderrCollector.waitForAllLines();
            return this.getResult(stdout, stderr, exitCode, null);
        }
        catch (com.google.devtools.mobileharness.shared.util.command.backend.CommandFailureException e) {
            int exitCode = e.result().exitCode();
            String stdout = this.stdoutCollector.waitForAllLines();
            String stderr = this.stderrCollector.waitForAllLines();
            return this.getResult(stdout, stderr, exitCode, e);
        }
    }

    public CommandResult await(Duration timeout) throws CommandFailureException, CommandTimeoutException, InterruptedException, TimeoutException {
        Instant deadline = Clock.systemUTC().instant().plus(timeout);
        try {
            int exitCode = this.backendProcess.await(Duration.between(Clock.systemUTC().instant(), deadline)).exitCode();
            String stdout = this.stdoutCollector.waitForAllLines(Duration.between(Clock.systemUTC().instant(), deadline));
            String stderr = this.stderrCollector.waitForAllLines(Duration.between(Clock.systemUTC().instant(), deadline));
            return this.getResult(stdout, stderr, exitCode, null);
        }
        catch (com.google.devtools.mobileharness.shared.util.command.backend.CommandFailureException e) {
            int exitCode = e.result().exitCode();
            String stdout = this.stdoutCollector.waitForAllLines(Duration.between(Clock.systemUTC().instant(), deadline));
            String stderr = this.stderrCollector.waitForAllLines(Duration.between(Clock.systemUTC().instant(), deadline));
            return this.getResult(stdout, stderr, exitCode, e);
        }
    }

    public void stop() {
        this.isStopped.set(true);
        this.kill();
    }

    public void kill() {
        this.backendProcess.kill();
    }

    public void killForcibly() {
        this.backendProcess.killForcibly();
    }

    public void killAndThenKillForcibly(Duration timeout) throws InterruptedException {
        try {
            this.kill();
            CommandResult commandResult = this.await(timeout);
        }
        catch (CommandExecutionException commandExecutionException) {
        }
        catch (TimeoutException e) {
            this.killForcibly();
        }
        catch (Error | InterruptedException | RuntimeException e) {
            this.killForcibly();
            throw e;
        }
    }

    @Beta
    public void killWithSignal(int signal) throws UnsupportedOperationException, InterruptedException {
        try {
            long pid = this.getPid();
            EXECUTOR.run(Command.of("kill", "-" + signal, Long.toString(pid)));
        }
        catch (CommandException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public boolean isAlive() {
        return this.backendProcess.isAlive() || this.stdoutCollector.notAllSourceClosed() || this.stderrCollector.notAllSourceClosed();
    }

    public OutputStream stdinStream() {
        return this.stdinStream;
    }

    public Writer stdinWriter() {
        return this.stdinWriter;
    }

    public Command command() {
        return this.command;
    }

    public ListenableFuture<Boolean> successfulStartFuture() {
        return this.successfulStartFuture;
    }

    public void stopReadingOutput() {
        this.stdoutCollector.stopConsumingLines();
        this.stderrCollector.stopConsumingLines();
    }

    void setTimeout() {
        this.isTimeout.set(true);
    }

    void setSuccessfulStart(boolean successfulStart) {
        this.successfulStartFuture.set(successfulStart);
    }

    private CommandResult getResult(String stdout, String stderr, int exitCode, @Nullable com.google.devtools.mobileharness.shared.util.command.backend.CommandFailureException backendFailureException) throws CommandFailureException, CommandTimeoutException {
        CommandResult result = CommandResults.of(stdout, stderr, exitCode, this.isTimeout.get(), this.isStopped.get());
        if (result.isTimeout()) {
            throw new CommandTimeoutException(this.command(), this.finalizedTimeout, this.finalizedStartTimeout, result);
        }
        if (result.isStopped() || backendFailureException == null) {
            return result;
        }
        throw new CommandFailureException(backendFailureException, this.command(), result);
    }

    public long getPid() {
        return this.backendProcess.processId();
    }
}

