/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.FluentLogger;
import com.google.common.io.ByteSink;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.controller.test.TestContext;
import com.google.devtools.mobileharness.shared.util.command.CommandBugChecker;
import com.google.devtools.mobileharness.shared.util.command.CommandException;
import com.google.devtools.mobileharness.shared.util.command.CommandExecutionException;
import com.google.devtools.mobileharness.shared.util.command.CommandProcess;
import com.google.devtools.mobileharness.shared.util.command.CommandResult;
import com.google.devtools.mobileharness.shared.util.command.CommandStartException;
import com.google.devtools.mobileharness.shared.util.command.LineCallback;
import com.google.devtools.mobileharness.shared.util.command.LineCallbackException;
import com.google.devtools.mobileharness.shared.util.command.Timeout;
import com.google.devtools.mobileharness.shared.util.command.backend.Command;
import com.google.devtools.mobileharness.shared.util.command.history.CommandRecord;
import com.google.devtools.mobileharness.shared.util.command.history.CommandRecorder;
import com.google.devtools.mobileharness.shared.util.command.io.LineCollector;
import com.google.devtools.mobileharness.shared.util.command.io.LineReader;
import com.google.devtools.mobileharness.shared.util.concurrent.ThreadPools;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;

public class CommandExecutor {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final ImmutableMap<String, String> SYSTEM_ENVIRONMENT = ImmutableMap.copyOf(System.getenv());
    private static final Timeout DEFAULT_COMMAND_TIMEOUT = Timeout.fixed(Duration.ofMinutes(5L));
    private static final boolean DEFAULT_REDIRECT_STDERR = true;
    private final ListeningExecutorService threadPool;
    private final ListeningScheduledExecutorService timer;
    private final com.google.devtools.mobileharness.shared.util.command.backend.CommandExecutor backend;
    private final CommandBugChecker bugChecker = new CommandBugChecker();
    private final Lock baseEnvironmentLock = new ReentrantLock();
    @GuardedBy(value="baseEnvironmentLock")
    private final Map<String, String> baseEnvironment = new HashMap<String, String>();
    private volatile Timeout defaultTimeout = DEFAULT_COMMAND_TIMEOUT;
    @Nullable
    private volatile Path defaultWorkDirectory;
    private volatile boolean defaultRedirectStderr = true;

    public static Builder newBuilder() {
        return new Builder();
    }

    public CommandExecutor() {
        this(LazyLoader.DEFAULT_THREAD_POOL, LazyLoader.DEFAULT_TIMER, Command.NATIVE_EXECUTOR);
    }

    private CommandExecutor(ListeningExecutorService threadPool, ListeningScheduledExecutorService timer, com.google.devtools.mobileharness.shared.util.command.backend.CommandExecutor backend) {
        this.threadPool = threadPool;
        this.timer = timer;
        this.backend = backend;
    }

    @CanIgnoreReturnValue
    public String run(com.google.devtools.mobileharness.shared.util.command.Command command) throws CommandException, InterruptedException {
        return this.exec(command).stdout();
    }

    @CheckReturnValue
    public ListenableFuture<String> asyncRun(com.google.devtools.mobileharness.shared.util.command.Command command) {
        return this.threadPool.submit(() -> this.run(command));
    }

    @CanIgnoreReturnValue
    public CommandResult exec(com.google.devtools.mobileharness.shared.util.command.Command command) throws CommandException, InterruptedException {
        CommandProcess commandProcess = this.start(command);
        try {
            return commandProcess.await();
        }
        catch (InterruptedException e) {
            ((FluentLogger.Api)logger.atFine()).log("Interrupted while awaiting result of command [%s], kill it", command);
            commandProcess.kill();
            throw e;
        }
    }

    @CheckReturnValue
    public ListenableFuture<CommandResult> asyncExec(com.google.devtools.mobileharness.shared.util.command.Command command) {
        return this.threadPool.submit(() -> this.exec(command));
    }

    @CheckReturnValue
    public CommandProcess start(com.google.devtools.mobileharness.shared.util.command.Command command) throws CommandStartException {
        com.google.devtools.mobileharness.shared.util.command.backend.CommandProcess backendProcess;
        CommandRecord commandRecord = CommandRecorder.getInstance().addCommand(command.getCommand());
        this.bugChecker.checkCommand(command);
        Duration remainingTime = CommandExecutor.getRemainingTime(command, command.getTimeout().orElse(this.getDefaultTimeout()));
        Optional<Timeout> startTimeout = command.getStartTimeout();
        Optional<Duration> startRemainingTime = startTimeout.isPresent() ? Optional.of(CommandExecutor.getRemainingTime(command, startTimeout.get())) : Optional.empty();
        boolean redirectStderr = command.getRedirectStderr().orElse(this.getDefaultRedirectStderr());
        LineReader stdoutReader = new LineReader();
        LineReader stderrReader = new LineReader();
        LineCollector stdoutCollector = new LineCollector(redirectStderr ? 2 : 1, command.getNeedStdoutInResult());
        LineCollector stderrCollector = new LineCollector(redirectStderr ? 0 : 1, command.getNeedStderrInResult());
        Command backendCommand = this.getBackendCommand(command, stdoutReader, stderrReader);
        try {
            backendProcess = this.backend.start(backendCommand);
        }
        catch (com.google.devtools.mobileharness.shared.util.command.backend.CommandStartException e) {
            throw new CommandStartException("Failed to start command", e, command);
        }
        CommandProcess commandProcess = new CommandProcess(command, backendProcess, stdoutCollector, stderrCollector, remainingTime, startRemainingTime.orElse(null));
        TestContext.TestContextRunnable timeoutTask = new TestContext.TestContextRunnable(new TimeoutTask(commandProcess));
        Function<Duration, ListenableFuture> timeoutTaskScheduler = timeout -> this.timer.schedule(timeoutTask, timeout.toMillis(), TimeUnit.MILLISECONDS);
        ListenableFuture timeoutTaskFuture = timeoutTaskScheduler.apply(remainingTime);
        ListenableFuture startTimeoutTaskFuture = startRemainingTime.map(timeoutTaskScheduler).orElse(null);
        CommandExecutor.writeToStdin(commandProcess, command.getInput().orElse(null));
        stdoutCollector.setLineConsumer(new LineConsumer(commandProcess, command.getStdoutLineCallback().orElse(null), startTimeoutTaskFuture));
        stderrCollector.setLineConsumer(new LineConsumer(commandProcess, command.getStderrLineCallback().orElse(null), startTimeoutTaskFuture));
        this.threadPool.execute(new TestContext.TestContextRunnable(() -> CommandExecutor.readOutput(stdoutReader, stdoutCollector, commandProcess.command())));
        this.threadPool.execute(new TestContext.TestContextRunnable(() -> CommandExecutor.readOutput(stderrReader, redirectStderr ? stdoutCollector : stderrCollector, commandProcess.command())));
        this.threadPool.execute(new TestContext.TestContextRunnable(() -> CommandExecutor.postRun(commandProcess, timeoutTaskFuture, startTimeoutTaskFuture, commandRecord)));
        return commandProcess;
    }

    @CanIgnoreReturnValue
    public CommandExecutor setBaseEnvironment(Map<String, String> baseEnvironment) {
        Preconditions.checkNotNull(baseEnvironment);
        this.baseEnvironmentLock.lock();
        try {
            this.baseEnvironment.clear();
            this.baseEnvironment.putAll(baseEnvironment);
        }
        finally {
            this.baseEnvironmentLock.unlock();
        }
        return this;
    }

    @CanIgnoreReturnValue
    public CommandExecutor updateBaseEnvironment(String key, String value) {
        this.baseEnvironmentLock.lock();
        try {
            this.baseEnvironment.put(key, value);
        }
        finally {
            this.baseEnvironmentLock.unlock();
        }
        return this;
    }

    public Map<String, String> getBaseEnvironment() {
        this.baseEnvironmentLock.lock();
        try {
            ImmutableMap<String, String> immutableMap = ImmutableMap.copyOf(this.baseEnvironment);
            return immutableMap;
        }
        finally {
            this.baseEnvironmentLock.unlock();
        }
    }

    @CanIgnoreReturnValue
    public CommandExecutor setDefaultTimeout(Timeout defaultTimeout) {
        this.defaultTimeout = Preconditions.checkNotNull(defaultTimeout);
        return this;
    }

    public Timeout getDefaultTimeout() {
        return this.defaultTimeout;
    }

    @CanIgnoreReturnValue
    public CommandExecutor setDefaultWorkDirectory(@Nullable Path defaultWorkDirectory) {
        this.defaultWorkDirectory = defaultWorkDirectory;
        return this;
    }

    public Optional<Path> getDefaultWorkDirectory() {
        return Optional.ofNullable(this.defaultWorkDirectory);
    }

    @CanIgnoreReturnValue
    public CommandExecutor setDefaultRedirectStderr(boolean defaultRedirectStderr) {
        this.defaultRedirectStderr = defaultRedirectStderr;
        return this;
    }

    public boolean getDefaultRedirectStderr() {
        return this.defaultRedirectStderr;
    }

    private Command getBackendCommand(com.google.devtools.mobileharness.shared.util.command.Command command, ByteSink stdoutSink, ByteSink stderrSink) {
        return Command.command(command.getExecutable(), command.getArguments().toArray(new String[0])).withSuccessCondition(result -> command.getSuccessExitCodes().contains(result.exitCode())).withEnvironment(SYSTEM_ENVIRONMENT).withEnvironmentUpdated(this.getBaseEnvironment()).withEnvironmentUpdated(command.getExtraEnvironment()).withWorkingDirectory(this.getCommandWorkDirectory(command)).withStdoutTo(stdoutSink).withStderrTo(stderrSink);
    }

    private Optional<Path> getCommandWorkDirectory(com.google.devtools.mobileharness.shared.util.command.Command command) {
        return command.getWorkDirectory().or(this::getDefaultWorkDirectory);
    }

    private static Duration getRemainingTime(com.google.devtools.mobileharness.shared.util.command.Command command, Timeout timeout) throws CommandStartException {
        try {
            return timeout.getRemainingTime();
        }
        catch (MobileHarnessException e) {
            throw new CommandStartException("Invalid command timeout", e, command);
        }
    }

    private static void writeToStdin(CommandProcess commandProcess, @Nullable String input) {
        if (input != null) {
            try {
                commandProcess.stdinWriter().write(input);
                commandProcess.stdinWriter().flush();
            }
            catch (IOException e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(e)).log("Failed to write [%s] to stdin of command [%s], kill it", (Object)input, (Object)commandProcess.command());
                commandProcess.kill();
            }
        }
    }

    private static void readOutput(LineReader lineReader, LineCollector lineCollector, com.google.devtools.mobileharness.shared.util.command.Command command) {
        try {
            lineReader.start(lineCollector);
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(e)).log("Failed to read from command [%s]", command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postRun(CommandProcess commandProcess, ListenableFuture<?> timeoutTaskFuture, @Nullable ListenableFuture<?> startTimeoutTaskFuture, CommandRecord commandRecord) {
        try {
            CommandResult result;
            try {
                result = commandProcess.await();
            }
            catch (CommandExecutionException e) {
                result = e.result();
            }
            finally {
                timeoutTaskFuture.cancel(false);
                if (startTimeoutTaskFuture != null) {
                    startTimeoutTaskFuture.cancel(false);
                }
                commandProcess.setSuccessfulStart(false);
            }
            CommandRecorder.getInstance().addCommandResult(commandRecord, result);
            CommandResult commandResult = result;
            commandProcess.command().getExitCallback().ifPresent(callback -> callback.accept(commandResult));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static <T extends Executor> T decorateWithLocalTraceSpan(T executor, Class<T> interfaceName) {
        return executor;
    }

    public static class Builder {
        private ListeningExecutorService threadPool;
        private ListeningScheduledExecutorService timer;
        private com.google.devtools.mobileharness.shared.util.command.backend.CommandExecutor backend;

        @CanIgnoreReturnValue
        public Builder setThreadPool(ListeningExecutorService threadPool) {
            this.threadPool = threadPool;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder useDefaultThreadPool(boolean propagateTraceContext) {
            return this.setThreadPool(propagateTraceContext ? LazyLoader.DEFAULT_THREAD_POOL : LazyLoader.DEFAULT_NON_PROPAGATING_THREAD_POOL);
        }

        @CanIgnoreReturnValue
        public Builder setTimer(ListeningScheduledExecutorService timer) {
            this.timer = timer;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setBackend(com.google.devtools.mobileharness.shared.util.command.backend.CommandExecutor backend) {
            this.backend = backend;
            return this;
        }

        public CommandExecutor build() {
            return new CommandExecutor(Preconditions.checkNotNull(this.threadPool), Preconditions.checkNotNull(this.timer), Preconditions.checkNotNull(this.backend));
        }

        private Builder() {
            this.setThreadPool(LazyLoader.DEFAULT_THREAD_POOL);
            this.setTimer(LazyLoader.DEFAULT_TIMER);
            this.setBackend(Command.NATIVE_EXECUTOR);
        }
    }

    private static class LazyLoader {
        private static final ListeningExecutorService DEFAULT_NON_PROPAGATING_THREAD_POOL = ThreadPools.createStandardThreadPool("default-mh-command-executor");
        private static final ListeningExecutorService DEFAULT_THREAD_POOL = CommandExecutor.decorateWithLocalTraceSpan(DEFAULT_NON_PROPAGATING_THREAD_POOL, ListeningExecutorService.class);
        private static final ListeningScheduledExecutorService DEFAULT_TIMER = CommandExecutor.decorateWithLocalTraceSpan(ThreadPools.createStandardScheduledThreadPool("default-mh-command-executor-timer", 30), ListeningScheduledExecutorService.class);

        private LazyLoader() {
        }
    }

    private class TimeoutTask
    implements Runnable {
        private final AtomicBoolean isStarted = new AtomicBoolean();
        private final CommandProcess commandProcess;

        private TimeoutTask(CommandProcess commandProcess) {
            this.commandProcess = commandProcess;
        }

        @Override
        public void run() {
            if (!this.isStarted.getAndSet(true)) {
                CommandExecutor.this.threadPool.execute(this::onTimeout);
            }
        }

        private void onTimeout() {
            ((FluentLogger.Api)logger.atInfo()).log("Kill timeout command: %s", this.commandProcess.command());
            this.commandProcess.setTimeout();
            this.commandProcess.kill();
            this.commandProcess.command().getTimeoutCallback().ifPresent(Runnable::run);
        }
    }

    @NotThreadSafe
    private static class LineConsumer
    implements Predicate<String> {
        private final CommandProcess commandProcess;
        @Nullable
        private final ListenableFuture<?> startTimeoutTaskFuture;
        @Nullable
        private LineCallback lineCallback;

        private LineConsumer(CommandProcess commandProcess, @Nullable LineCallback lineCallback, @Nullable ListenableFuture<?> startTimeoutTaskFuture) {
            this.commandProcess = commandProcess;
            this.lineCallback = lineCallback;
            this.startTimeoutTaskFuture = startTimeoutTaskFuture;
        }

        @Override
        public boolean test(String line) {
            if (this.testSuccessfulStart(line)) {
                if (this.startTimeoutTaskFuture != null) {
                    this.startTimeoutTaskFuture.cancel(false);
                }
                this.commandProcess.setSuccessfulStart(true);
            }
            if (this.lineCallback != null) {
                LineCallback.Response response = null;
                try {
                    response = this.lineCallback.onLine(line);
                }
                catch (LineCallbackException e) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause(e)).log("Line callback error of command [%s], line=[%s]", (Object)this.commandProcess.command(), (Object)line);
                    if (e.getKillCommand()) {
                        ((FluentLogger.Api)logger.atFine()).log("Kill command [%s] by its callback error, line=[%s]", (Object)this.commandProcess.command(), (Object)line);
                        this.commandProcess.kill();
                    }
                    if (e.getStopReadingOutput()) {
                        this.lineCallback = null;
                    }
                }
                catch (RuntimeException e) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(e)).log("Line callback runtime exception, command=[%s], line=[%s]", (Object)this.commandProcess.command(), (Object)line);
                }
                if (response != null) {
                    CommandExecutor.writeToStdin(this.commandProcess, response.getAnswer().orElse(null));
                    if (response.getStop()) {
                        ((FluentLogger.Api)logger.atFine()).log("Stop command [%s] by its callback, line=[%s]", (Object)this.commandProcess.command(), (Object)line);
                        this.commandProcess.stop();
                    }
                    if (response.getStopReadingOutput()) {
                        this.lineCallback = null;
                    }
                }
            }
            return this.lineCallback == null && this.commandProcess.successfulStartFuture().isDone() && Boolean.TRUE.equals(Futures.getUnchecked(this.commandProcess.successfulStartFuture()));
        }

        private boolean testSuccessfulStart(String line) {
            try {
                return this.commandProcess.command().getSuccessfulStartCondition().test(line);
            }
            catch (RuntimeException e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(e)).log("Error when testing successful start condition of command [%s] with line [%s]", (Object)this.commandProcess.command(), (Object)line);
                return false;
            }
        }
    }
}

