/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.mobileharness.shared.util.command.AutoValue_Command;
import com.google.devtools.mobileharness.shared.util.command.Command;
import com.google.devtools.mobileharness.shared.util.command.CommandResult;
import com.google.devtools.mobileharness.shared.util.command.LineCallback;
import com.google.devtools.mobileharness.shared.util.command.Timeout;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

abstract class $AutoValue_Command
extends Command {
    private final String executable;
    private final ImmutableList<String> arguments;
    private final Optional<Timeout> timeout;
    private final Optional<Timeout> startTimeout;
    private final Predicate<String> successfulStartCondition;
    private final Optional<Runnable> timeoutCallback;
    private final Optional<LineCallback> stdoutLineCallback;
    private final Optional<LineCallback> stderrLineCallback;
    private final Optional<Consumer<CommandResult>> exitCallback;
    private final ImmutableSet<Integer> successExitCodes;
    private final Optional<String> input;
    private final Optional<Path> workDirectory;
    private final ImmutableMap<String, String> extraEnvironment;
    private final Optional<Boolean> redirectStderr;
    private final boolean needStdoutInResult;
    private final boolean needStderrInResult;
    private final boolean showFullResultInException;

    $AutoValue_Command(String executable, ImmutableList<String> arguments, Optional<Timeout> timeout, Optional<Timeout> startTimeout, Predicate<String> successfulStartCondition, Optional<Runnable> timeoutCallback, Optional<LineCallback> stdoutLineCallback, Optional<LineCallback> stderrLineCallback, Optional<Consumer<CommandResult>> exitCallback, ImmutableSet<Integer> successExitCodes, Optional<String> input, Optional<Path> workDirectory, ImmutableMap<String, String> extraEnvironment, Optional<Boolean> redirectStderr, boolean needStdoutInResult, boolean needStderrInResult, boolean showFullResultInException) {
        if (executable == null) {
            throw new NullPointerException("Null executable");
        }
        this.executable = executable;
        if (arguments == null) {
            throw new NullPointerException("Null arguments");
        }
        this.arguments = arguments;
        if (timeout == null) {
            throw new NullPointerException("Null timeout");
        }
        this.timeout = timeout;
        if (startTimeout == null) {
            throw new NullPointerException("Null startTimeout");
        }
        this.startTimeout = startTimeout;
        if (successfulStartCondition == null) {
            throw new NullPointerException("Null successfulStartCondition");
        }
        this.successfulStartCondition = successfulStartCondition;
        if (timeoutCallback == null) {
            throw new NullPointerException("Null timeoutCallback");
        }
        this.timeoutCallback = timeoutCallback;
        if (stdoutLineCallback == null) {
            throw new NullPointerException("Null stdoutLineCallback");
        }
        this.stdoutLineCallback = stdoutLineCallback;
        if (stderrLineCallback == null) {
            throw new NullPointerException("Null stderrLineCallback");
        }
        this.stderrLineCallback = stderrLineCallback;
        if (exitCallback == null) {
            throw new NullPointerException("Null exitCallback");
        }
        this.exitCallback = exitCallback;
        if (successExitCodes == null) {
            throw new NullPointerException("Null successExitCodes");
        }
        this.successExitCodes = successExitCodes;
        if (input == null) {
            throw new NullPointerException("Null input");
        }
        this.input = input;
        if (workDirectory == null) {
            throw new NullPointerException("Null workDirectory");
        }
        this.workDirectory = workDirectory;
        if (extraEnvironment == null) {
            throw new NullPointerException("Null extraEnvironment");
        }
        this.extraEnvironment = extraEnvironment;
        if (redirectStderr == null) {
            throw new NullPointerException("Null redirectStderr");
        }
        this.redirectStderr = redirectStderr;
        this.needStdoutInResult = needStdoutInResult;
        this.needStderrInResult = needStderrInResult;
        this.showFullResultInException = showFullResultInException;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    @Override
    public ImmutableList<String> getArguments() {
        return this.arguments;
    }

    @Override
    public Optional<Timeout> getTimeout() {
        return this.timeout;
    }

    @Override
    public Optional<Timeout> getStartTimeout() {
        return this.startTimeout;
    }

    @Override
    public Predicate<String> getSuccessfulStartCondition() {
        return this.successfulStartCondition;
    }

    @Override
    public Optional<Runnable> getTimeoutCallback() {
        return this.timeoutCallback;
    }

    @Override
    public Optional<LineCallback> getStdoutLineCallback() {
        return this.stdoutLineCallback;
    }

    @Override
    public Optional<LineCallback> getStderrLineCallback() {
        return this.stderrLineCallback;
    }

    @Override
    public Optional<Consumer<CommandResult>> getExitCallback() {
        return this.exitCallback;
    }

    @Override
    public ImmutableSet<Integer> getSuccessExitCodes() {
        return this.successExitCodes;
    }

    @Override
    public Optional<String> getInput() {
        return this.input;
    }

    @Override
    public Optional<Path> getWorkDirectory() {
        return this.workDirectory;
    }

    @Override
    public ImmutableMap<String, String> getExtraEnvironment() {
        return this.extraEnvironment;
    }

    @Override
    public Optional<Boolean> getRedirectStderr() {
        return this.redirectStderr;
    }

    @Override
    public boolean getNeedStdoutInResult() {
        return this.needStdoutInResult;
    }

    @Override
    public boolean getNeedStderrInResult() {
        return this.needStderrInResult;
    }

    @Override
    public boolean getShowFullResultInException() {
        return this.showFullResultInException;
    }

    @Override
    Command.Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder
    extends Command.Builder {
        private String executable;
        private ImmutableList<String> arguments;
        private Optional<Timeout> timeout = Optional.empty();
        private Optional<Timeout> startTimeout = Optional.empty();
        private Predicate<String> successfulStartCondition;
        private Optional<Runnable> timeoutCallback = Optional.empty();
        private Optional<LineCallback> stdoutLineCallback = Optional.empty();
        private Optional<LineCallback> stderrLineCallback = Optional.empty();
        private Optional<Consumer<CommandResult>> exitCallback = Optional.empty();
        private ImmutableSet<Integer> successExitCodes;
        private Optional<String> input = Optional.empty();
        private Optional<Path> workDirectory = Optional.empty();
        private ImmutableMap<String, String> extraEnvironment;
        private Optional<Boolean> redirectStderr = Optional.empty();
        private boolean needStdoutInResult;
        private boolean needStderrInResult;
        private boolean showFullResultInException;
        private byte set$0;

        Builder() {
        }

        private Builder(Command source) {
            this.executable = source.getExecutable();
            this.arguments = source.getArguments();
            this.timeout = source.getTimeout();
            this.startTimeout = source.getStartTimeout();
            this.successfulStartCondition = source.getSuccessfulStartCondition();
            this.timeoutCallback = source.getTimeoutCallback();
            this.stdoutLineCallback = source.getStdoutLineCallback();
            this.stderrLineCallback = source.getStderrLineCallback();
            this.exitCallback = source.getExitCallback();
            this.successExitCodes = source.getSuccessExitCodes();
            this.input = source.getInput();
            this.workDirectory = source.getWorkDirectory();
            this.extraEnvironment = source.getExtraEnvironment();
            this.redirectStderr = source.getRedirectStderr();
            this.needStdoutInResult = source.getNeedStdoutInResult();
            this.needStderrInResult = source.getNeedStderrInResult();
            this.showFullResultInException = source.getShowFullResultInException();
            this.set$0 = (byte)7;
        }

        @Override
        Command.Builder executable(String executable) {
            if (executable == null) {
                throw new NullPointerException("Null executable");
            }
            this.executable = executable;
            return this;
        }

        @Override
        Command.Builder arguments(List<String> arguments) {
            this.arguments = ImmutableList.copyOf(arguments);
            return this;
        }

        @Override
        Command.Builder timeout(Timeout timeout) {
            this.timeout = Optional.of(timeout);
            return this;
        }

        @Override
        Command.Builder startTimeout(Timeout startTimeout) {
            this.startTimeout = Optional.of(startTimeout);
            return this;
        }

        @Override
        Command.Builder successfulStartCondition(Predicate<String> successfulStartCondition) {
            if (successfulStartCondition == null) {
                throw new NullPointerException("Null successfulStartCondition");
            }
            this.successfulStartCondition = successfulStartCondition;
            return this;
        }

        @Override
        Command.Builder timeoutCallback(Runnable timeoutCallback) {
            this.timeoutCallback = Optional.of(timeoutCallback);
            return this;
        }

        @Override
        Command.Builder stdoutLineCallback(LineCallback stdoutLineCallback) {
            this.stdoutLineCallback = Optional.of(stdoutLineCallback);
            return this;
        }

        @Override
        Command.Builder stderrLineCallback(LineCallback stderrLineCallback) {
            this.stderrLineCallback = Optional.of(stderrLineCallback);
            return this;
        }

        @Override
        Command.Builder exitCallback(Consumer<CommandResult> exitCallback) {
            this.exitCallback = Optional.of(exitCallback);
            return this;
        }

        @Override
        Command.Builder successExitCodes(Set<Integer> successExitCodes) {
            this.successExitCodes = ImmutableSet.copyOf(successExitCodes);
            return this;
        }

        @Override
        Command.Builder input(String input) {
            this.input = Optional.of(input);
            return this;
        }

        @Override
        Command.Builder workDirectory(Path workDirectory) {
            this.workDirectory = Optional.of(workDirectory);
            return this;
        }

        @Override
        Command.Builder extraEnvironment(Map<String, String> extraEnvironment) {
            this.extraEnvironment = ImmutableMap.copyOf(extraEnvironment);
            return this;
        }

        @Override
        Command.Builder redirectStderr(boolean redirectStderr) {
            this.redirectStderr = Optional.of(redirectStderr);
            return this;
        }

        @Override
        Command.Builder needStdoutInResult(boolean needStdoutInResult) {
            this.needStdoutInResult = needStdoutInResult;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        Command.Builder needStderrInResult(boolean needStderrInResult) {
            this.needStderrInResult = needStderrInResult;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        Command.Builder showFullResultInException(boolean showFullResultInException) {
            this.showFullResultInException = showFullResultInException;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        Command build() {
            if (this.set$0 != 7 || this.executable == null || this.arguments == null || this.successfulStartCondition == null || this.successExitCodes == null || this.extraEnvironment == null) {
                StringBuilder missing = new StringBuilder();
                if (this.executable == null) {
                    missing.append(" executable");
                }
                if (this.arguments == null) {
                    missing.append(" arguments");
                }
                if (this.successfulStartCondition == null) {
                    missing.append(" successfulStartCondition");
                }
                if (this.successExitCodes == null) {
                    missing.append(" successExitCodes");
                }
                if (this.extraEnvironment == null) {
                    missing.append(" extraEnvironment");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" needStdoutInResult");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" needStderrInResult");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" showFullResultInException");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_Command(this.executable, this.arguments, this.timeout, this.startTimeout, this.successfulStartCondition, this.timeoutCallback, this.stdoutLineCallback, this.stderrLineCallback, this.exitCallback, this.successExitCodes, this.input, this.workDirectory, this.extraEnvironment, this.redirectStderr, this.needStdoutInResult, this.needStderrInResult, this.showFullResultInException);
        }
    }
}

