/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.base;

import com.google.devtools.mobileharness.shared.util.base.ProtoExtensionRegistry;
import com.google.devtools.mobileharness.shared.util.base.ProtoReflectionUtil;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;

public class ProtoTextFormat {
    private static final TextFormat.Printer DEBUG_PRINTER = TextFormat.printer();
    private static final TextFormat.Parser PARSER = TextFormat.Parser.newBuilder().setAllowUnknownFields(true).setAllowUnknownExtensions(true).build();

    public static String shortDebugString(MessageOrBuilder message) {
        return ProtoTextFormat.shortDebugStringWithPrinterOss(message, DEBUG_PRINTER);
    }

    public static String shortDebugStringWithPrinter(MessageOrBuilder message, TextFormat.Printer printer) {
        return ProtoTextFormat.shortDebugStringWithPrinterOss(message, printer);
    }

    private static String shortDebugStringWithPrinterOss(MessageOrBuilder message, TextFormat.Printer printer) {
        return printer.shortDebugString(message);
    }

    public static <T extends Message> T parse(CharSequence textproto, Class<T> protoClass) throws TextFormat.ParseException {
        return ProtoTextFormat.parse(textproto, ProtoExtensionRegistry.getGeneratedRegistry(), protoClass);
    }

    public static <T extends Message> T parse(CharSequence textproto, ExtensionRegistry extensionRegistry, Class<T> protoClass) throws TextFormat.ParseException {
        Message.Builder builder = ProtoReflectionUtil.newInstance(protoClass, Message.Builder.class);
        PARSER.merge(textproto, extensionRegistry, builder);
        return (T)builder.build();
    }

    private ProtoTextFormat() {
    }
}

