/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite.subplan;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.devtools.mobileharness.platform.android.xts.suite.SuiteTestFilter;
import com.google.devtools.mobileharness.platform.android.xts.suite.subplan.AbstractXmlParser;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class SubPlan
extends AbstractXmlParser {
    private final HashMultimap<String, String> includeFiltersMultimap = HashMultimap.create();
    private final HashMultimap<String, String> excludeFiltersMultimap = HashMultimap.create();
    private final HashMultimap<String, String> nonTfIncludeFiltersMultimap = HashMultimap.create();
    private final HashMultimap<String, String> nonTfExcludeFiltersMultimap = HashMultimap.create();
    private static final String ENCODING = "UTF-8";
    private static final String NS = null;
    private static final String VERSION_ATTR = "version";
    private static final String SUBPLAN_VERSION = "2.0";
    private static final String SUBPLAN_TAG = "SubPlan";
    private static final String ENTRY_TAG = "Entry";
    private static final String EXCLUDE_ATTR = "exclude";
    private static final String INCLUDE_ATTR = "include";
    private static final String ABI_ATTR = "abi";
    private static final String NAME_ATTR = "name";
    private static final String IS_NON_TF_ATTR = "isNonTf";
    public static final String ALL_TESTS_IN_MODULE = "ALL";
    private String prevSessionXtsTestPlan = "";
    private String prevSessionDeviceBuildFingerprint;
    private String prevSessionDeviceBuildFingerprintUnaltered;
    private String prevSessionDeviceVendorBuildFingerprint;

    public void addIncludeFilter(String filter) {
        SubPlan.addFilterHelper(this.includeFiltersMultimap, filter);
    }

    public void addAllIncludeFilters(Set<String> filters) {
        for (String filter : filters) {
            this.addIncludeFilter(filter);
        }
    }

    public void addNonTfIncludeFilter(String filter) {
        SubPlan.addFilterHelper(this.nonTfIncludeFiltersMultimap, filter);
    }

    public void addExcludeFilter(String filter) {
        SubPlan.addFilterHelper(this.excludeFiltersMultimap, filter);
    }

    public void addAllExcludeFilters(Set<String> filters) {
        for (String filter : filters) {
            this.addExcludeFilter(filter);
        }
    }

    public void addNonTfExcludeFilter(String filter) {
        SubPlan.addFilterHelper(this.nonTfExcludeFiltersMultimap, filter);
    }

    private static void addFilterHelper(HashMultimap<String, String> multiMap, String filter) {
        SuiteTestFilter suiteTestFilter = SuiteTestFilter.create(filter);
        multiMap.put((Object)((String)(suiteTestFilter.abi().isPresent() ? suiteTestFilter.abi().get() + " " : "") + suiteTestFilter.moduleName()), (Object)suiteTestFilter.testName().orElse(ALL_TESTS_IN_MODULE));
    }

    public SetMultimap<String, String> getIncludeFiltersMultimap() {
        return HashMultimap.create(this.includeFiltersMultimap);
    }

    public SetMultimap<String, String> getNonTfIncludeFiltersMultimap() {
        return HashMultimap.create(this.nonTfIncludeFiltersMultimap);
    }

    public boolean hasAnyTfIncludeFilters() {
        return !this.includeFiltersMultimap.isEmpty();
    }

    public boolean hasAnyNonTfIncludeFilters() {
        return !this.nonTfIncludeFiltersMultimap.isEmpty();
    }

    public SetMultimap<String, String> getExcludeFiltersMultimap() {
        return HashMultimap.create(this.excludeFiltersMultimap);
    }

    public SetMultimap<String, String> getNonTfExcludeFiltersMultimap() {
        return HashMultimap.create(this.nonTfExcludeFiltersMultimap);
    }

    public boolean hasAnyTfExcludeFilters() {
        return !this.excludeFiltersMultimap.isEmpty();
    }

    public boolean hasAnyNonTfExcludeFilters() {
        return !this.nonTfExcludeFiltersMultimap.isEmpty();
    }

    public void clearIncludeFilters() {
        this.includeFiltersMultimap.clear();
        this.nonTfIncludeFiltersMultimap.clear();
    }

    public void clearExcludeFilters() {
        this.includeFiltersMultimap.clear();
        this.nonTfExcludeFiltersMultimap.clear();
    }

    public void setPreviousSessionXtsTestPlan(String prevSessionXtsTestPlan) {
        this.prevSessionXtsTestPlan = prevSessionXtsTestPlan;
    }

    public String getPreviousSessionXtsTestPlan() {
        return this.prevSessionXtsTestPlan;
    }

    public void setPreviousSessionDeviceBuildFingerprint(String prevSessionDeviceBuildFingerprint) {
        this.prevSessionDeviceBuildFingerprint = prevSessionDeviceBuildFingerprint;
    }

    public Optional<String> getPreviousSessionDeviceBuildFingerprint() {
        return Optional.ofNullable(this.prevSessionDeviceBuildFingerprint);
    }

    public void setPreviousSessionDeviceBuildFingerprintUnaltered(String prevSessionDeviceBuildFingerprintUnaltered) {
        this.prevSessionDeviceBuildFingerprintUnaltered = prevSessionDeviceBuildFingerprintUnaltered;
    }

    public Optional<String> getPreviousSessionDeviceBuildFingerprintUnaltered() {
        return Optional.ofNullable(this.prevSessionDeviceBuildFingerprintUnaltered);
    }

    public void setPreviousSessionDeviceVendorBuildFingerprint(String prevSessionDeviceVendorBuildFingerprint) {
        this.prevSessionDeviceVendorBuildFingerprint = prevSessionDeviceVendorBuildFingerprint;
    }

    public Optional<String> getPreviousSessionDeviceVendorBuildFingerprint() {
        return Optional.ofNullable(this.prevSessionDeviceVendorBuildFingerprint);
    }

    public ImmutableList<String> getAllIncludeFilters() {
        ImmutableList.Builder includeFilters = ImmutableList.builder();
        return ((ImmutableList.Builder)((ImmutableList.Builder)includeFilters.addAll(SubPlan.getFiltersFromMap(this.includeFiltersMultimap, true, false))).addAll(SubPlan.getFiltersFromMap(this.nonTfIncludeFiltersMultimap, true, false))).build();
    }

    public ImmutableList<String> getAllExcludeFilters() {
        ImmutableList.Builder excludeFilters = ImmutableList.builder();
        return ((ImmutableList.Builder)((ImmutableList.Builder)excludeFilters.addAll(SubPlan.getFiltersFromMap(this.excludeFiltersMultimap, false, false))).addAll(SubPlan.getFiltersFromMap(this.nonTfExcludeFiltersMultimap, false, false))).build();
    }

    public void serialize(OutputStream xmlOutputStream, boolean tfFiltersOnly) throws IOException {
        this.serialize(xmlOutputStream, tfFiltersOnly, false);
    }

    public void serialize(OutputStream xmlOutputStream, boolean tfFiltersOnly, boolean sortFiltersByNaturalOrder) throws IOException {
        XmlSerializer serializer = null;
        try {
            serializer = XmlPullParserFactory.newInstance().newSerializer();
        }
        catch (XmlPullParserException e) {
            try {
                xmlOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException(e);
        }
        serializer.setOutput(xmlOutputStream, ENCODING);
        serializer.startDocument(ENCODING, false);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.startTag(NS, SUBPLAN_TAG);
        serializer.attribute(NS, VERSION_ATTR, SUBPLAN_VERSION);
        this.serializeFiltersMultimap(serializer, this.includeFiltersMultimap, true, false, sortFiltersByNaturalOrder);
        this.serializeFiltersMultimap(serializer, this.excludeFiltersMultimap, false, false, sortFiltersByNaturalOrder);
        if (!tfFiltersOnly) {
            this.serializeFiltersMultimap(serializer, this.nonTfIncludeFiltersMultimap, true, true, sortFiltersByNaturalOrder);
            this.serializeFiltersMultimap(serializer, this.nonTfExcludeFiltersMultimap, false, true, sortFiltersByNaturalOrder);
        }
        serializer.endTag(NS, SUBPLAN_TAG);
        serializer.endDocument();
    }

    private void serializeFiltersMultimap(XmlSerializer serializer, HashMultimap<String, String> filtersMultimap, boolean isIncludeFilter, boolean isNonTf, boolean sortFiltersByNaturalOrder) throws IOException {
        SubPlan.processFiltersFromFiltersMultimap(filtersMultimap, isIncludeFilter, filter -> this.serializeOneEntry(serializer, filter, isIncludeFilter, isNonTf), sortFiltersByNaturalOrder);
    }

    private void serializeOneEntry(XmlSerializer serializer, String filter, boolean isIncludeFilter, boolean isNonTf) throws IOException {
        serializer.startTag(NS, ENTRY_TAG);
        serializer.attribute(NS, isIncludeFilter ? INCLUDE_ATTR : EXCLUDE_ATTR, filter);
        if (isNonTf) {
            serializer.attribute(NS, IS_NON_TF_ATTR, "true");
        }
        serializer.endTag(NS, ENTRY_TAG);
    }

    private static ImmutableList<String> getFiltersFromMap(HashMultimap<String, String> map, boolean isIncludeFilter, boolean sortFiltersByNaturalOrder) {
        ImmutableList.Builder filters = ImmutableList.builder();
        try {
            SubPlan.processFiltersFromFiltersMultimap(map, isIncludeFilter, filters::add, sortFiltersByNaturalOrder);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return filters.build();
    }

    private static void processFiltersFromFiltersMultimap(HashMultimap<String, String> filtersMultimap, boolean isIncludeFilter, FilterHandler filterHandler, boolean sortFiltersByNaturalOrder) throws IOException {
        ImmutableList listOfSetFilters = Multimaps.asMap(filtersMultimap).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> {
            Set valueSet = sortFiltersByNaturalOrder ? (Set)((Set)entry.getValue()).stream().sorted().collect(ImmutableSet.toImmutableSet()) : (Set)entry.getValue();
            return new AbstractMap.SimpleEntry<String, Set>((String)entry.getKey(), valueSet);
        }).collect(ImmutableList.toImmutableList());
        for (Map.Entry entry2 : listOfSetFilters) {
            boolean includeOrExcludeWholeModule = ((Set)entry2.getValue()).contains(ALL_TESTS_IN_MODULE);
            if (!isIncludeFilter && includeOrExcludeWholeModule) {
                filterHandler.handleOneFilter((String)entry2.getKey());
                continue;
            }
            if (includeOrExcludeWholeModule && ((Set)entry2.getValue()).size() == 1) {
                filterHandler.handleOneFilter((String)entry2.getKey());
                continue;
            }
            for (String testName : (Set)entry2.getValue()) {
                if (testName.equals(ALL_TESTS_IN_MODULE)) continue;
                filterHandler.handleOneFilter((String)entry2.getKey() + " " + testName);
            }
        }
    }

    @Override
    protected DefaultHandler createXmlHandler() {
        return new EntryHandler();
    }

    @FunctionalInterface
    private static interface FilterHandler {
        public void handleOneFilter(String var1) throws IOException;
    }

    private class EntryHandler
    extends DefaultHandler {
        private EntryHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (Objects.equals(localName, SubPlan.ENTRY_TAG)) {
                String includeString = attributes.getValue(SubPlan.INCLUDE_ATTR);
                String excludeString = attributes.getValue(SubPlan.EXCLUDE_ATTR);
                if (includeString != null && excludeString != null) {
                    throw new IllegalArgumentException("Cannot specify include and exclude filter in the same element");
                }
                String abiString = attributes.getValue(SubPlan.ABI_ATTR);
                String nameString = attributes.getValue(SubPlan.NAME_ATTR);
                boolean isNonTf = Boolean.parseBoolean(attributes.getValue(SubPlan.IS_NON_TF_ATTR));
                if (excludeString == null) {
                    this.parseFilter(abiString, nameString, includeString, isNonTf ? SubPlan.this.nonTfIncludeFiltersMultimap : SubPlan.this.includeFiltersMultimap);
                } else {
                    this.parseFilter(abiString, nameString, excludeString, isNonTf ? SubPlan.this.nonTfExcludeFiltersMultimap : SubPlan.this.excludeFiltersMultimap);
                }
            }
        }

        private void parseFilter(String abi, String name, String filter, HashMultimap<String, String> filtersMultimap) {
            if (name == null) {
                SubPlan.addFilterHelper(filtersMultimap, filter);
            } else {
                StringBuilder newFilter = new StringBuilder();
                if (abi != null) {
                    newFilter.append(abi.trim());
                    newFilter.append(' ');
                }
                if (name != null) {
                    newFilter.append(name.trim());
                }
                if (filter != null) {
                    newFilter.append(' ');
                    newFilter.append(filter.trim());
                }
                SubPlan.addFilterHelper(filtersMultimap, newFilter.toString());
            }
        }
    }
}

