/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.common.util;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.api.model.error.ExtErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.shared.util.command.Command;
import com.google.devtools.mobileharness.shared.util.command.CommandException;
import com.google.devtools.mobileharness.shared.util.command.CommandExecutor;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbiUtil {
    public static final String ABI_ARM_V7A = "armeabi-v7a";
    public static final String ABI_ARM_64_V8A = "arm64-v8a";
    public static final String ABI_X86 = "x86";
    public static final String ABI_X86_64 = "x86_64";
    public static final String ABI_MIPS = "mips";
    public static final String ABI_MIPS64 = "mips64";
    public static final String ABI_RISCV64 = "riscv64";
    public static final String BASE_ARCH_ARM = "arm";
    public static final String ARCH_ARM64 = "arm64";
    public static final String BASE_ARCH_X86 = "x86";
    public static final String ARCH_X86_64 = "x86_64";
    public static final String BASE_ARCH_MIPS = "mips";
    public static final String ARCH_MIPS64 = "mips64";
    public static final String ARCH_RISCV64 = "riscv64";
    private static final Set<String> abis32bit = new LinkedHashSet<String>();
    private static final Set<String> abis64bit = new LinkedHashSet<String>();
    protected static final Set<String> armAbis = new LinkedHashSet<String>();
    private static final Set<String> intelAbis = new LinkedHashSet<String>();
    private static final Set<String> mipsAbis = new LinkedHashSet<String>();
    private static final Set<String> riscvAbis = new LinkedHashSet<String>();
    protected static final Set<String> abisSupportedByCompatibility = new LinkedHashSet<String>();
    private static final Set<String> archSupported = new LinkedHashSet<String>();
    private static final Map<String, Set<String>> archToAbis = new LinkedHashMap<String, Set<String>>();
    private static final Map<String, String> abiToArch = new LinkedHashMap<String, String>();
    private static final Map<String, String> abiToBaseArch = new LinkedHashMap<String, String>();

    private AbiUtil() {
    }

    public static Set<String> getAbisForArch(String arch) {
        if (Strings.isNullOrEmpty(arch) || !archToAbis.containsKey(arch)) {
            return AbiUtil.getAbisSupportedByCompatibility();
        }
        return new LinkedHashSet<String>((Collection)archToAbis.get(arch));
    }

    public static String getArchForAbi(String abi) {
        if (Strings.isNullOrEmpty(abi)) {
            throw new IllegalArgumentException("Abi cannot be null or empty");
        }
        return abiToArch.get(abi);
    }

    public static String getBaseArchForAbi(String abi) {
        if (Strings.isNullOrEmpty(abi)) {
            throw new IllegalArgumentException("Abi cannot be null or empty");
        }
        return abiToBaseArch.get(abi);
    }

    public static Set<String> getAbisSupportedByCompatibility() {
        return new LinkedHashSet<String>(abisSupportedByCompatibility);
    }

    public static Set<String> getArchSupported() {
        return new LinkedHashSet<String>(archSupported);
    }

    public static boolean isAbiSupportedByCompatibility(String abi) {
        return abisSupportedByCompatibility.contains(abi);
    }

    public static String createAbiFlag(String abi) {
        if (Strings.isNullOrEmpty(abi) || !AbiUtil.isAbiSupportedByCompatibility(abi)) {
            return "";
        }
        return String.format("--abi %s ", abi);
    }

    public static String createId(String abi, String name) {
        return String.format("%s %s", abi, name);
    }

    public static ImmutableList<String> parseId(String id) {
        if (id == null || !id.contains(" ")) {
            return ImmutableList.of("", "");
        }
        return Splitter.on(' ').splitToStream(id).collect(ImmutableList.toImmutableList());
    }

    public static String parseTestName(String id) {
        return (String)AbiUtil.parseId(id).get(1);
    }

    public static String parseAbi(String id) {
        return (String)AbiUtil.parseId(id).get(0);
    }

    public static String getBitness(String abi) {
        return abis32bit.contains(abi) ? "32" : "64";
    }

    public static Set<String> parseAbiList(String unsupportedAbiDescription) {
        HashSet<String> abiSet = new HashSet<String>();
        List<String> descSegments = Splitter.on(":").splitToList(unsupportedAbiDescription);
        if (descSegments.size() == 2) {
            for (String abi : Splitter.on(",").splitToList(descSegments.get(1))) {
                String trimmedAbi = abi.trim();
                if (!AbiUtil.isAbiSupportedByCompatibility(trimmedAbi)) continue;
                abiSet.add(trimmedAbi);
            }
        }
        return abiSet;
    }

    public static Set<String> parseAbiListFromProperty(String abiListProp) {
        HashSet<String> abiSet = new HashSet<String>();
        if (abiListProp == null) {
            return abiSet;
        }
        List<String> abiList = Splitter.on(",").splitToList(abiListProp);
        for (String abi : abiList) {
            String trimmedAbi = abi.trim();
            if (!AbiUtil.isAbiSupportedByCompatibility(trimmedAbi)) continue;
            abiSet.add(trimmedAbi);
        }
        return abiSet;
    }

    public static Set<String> getHostAbi() throws MobileHarnessException, InterruptedException {
        CommandExecutor cmdExecutor = new CommandExecutor();
        try {
            String mainAbi = cmdExecutor.run(Command.of("uname", "-m")).trim();
            return AbiUtil.getAbisForArch(mainAbi);
        }
        catch (CommandException e) {
            throw new MobileHarnessException(ExtErrorId.ABI_UTIL_GET_HOST_ABI_ERROR, "Failed to get host ABI", e);
        }
    }

    static {
        abis32bit.add(ABI_ARM_V7A);
        abis32bit.add("x86");
        abis32bit.add("mips");
        abis64bit.add(ABI_ARM_64_V8A);
        abis64bit.add("x86_64");
        abis64bit.add("mips64");
        abis64bit.add("riscv64");
        armAbis.add(ABI_ARM_64_V8A);
        armAbis.add(ABI_ARM_V7A);
        intelAbis.add("x86_64");
        intelAbis.add("x86");
        mipsAbis.add("mips64");
        mipsAbis.add("mips");
        riscvAbis.add("riscv64");
        archToAbis.put(BASE_ARCH_ARM, armAbis);
        archToAbis.put(ARCH_ARM64, armAbis);
        archToAbis.put("x86", intelAbis);
        archToAbis.put("x86_64", intelAbis);
        archToAbis.put("mips", mipsAbis);
        archToAbis.put("mips64", mipsAbis);
        archToAbis.put("riscv64", riscvAbis);
        abisSupportedByCompatibility.addAll(armAbis);
        abisSupportedByCompatibility.addAll(intelAbis);
        abisSupportedByCompatibility.addAll(mipsAbis);
        abisSupportedByCompatibility.addAll(riscvAbis);
        abiToArch.put(ABI_ARM_V7A, BASE_ARCH_ARM);
        abiToArch.put(ABI_ARM_64_V8A, ARCH_ARM64);
        abiToArch.put("x86", "x86");
        abiToArch.put("x86_64", "x86_64");
        abiToArch.put("mips", "mips");
        abiToArch.put("mips64", "mips64");
        abiToArch.put("riscv64", "riscv64");
        abiToBaseArch.put(ABI_ARM_V7A, BASE_ARCH_ARM);
        abiToBaseArch.put(ABI_ARM_64_V8A, BASE_ARCH_ARM);
        abiToBaseArch.put("x86", "x86");
        abiToBaseArch.put("x86_64", "x86");
        abiToBaseArch.put("mips", "mips");
        abiToBaseArch.put("mips64", "mips");
        abiToBaseArch.put("riscv64", "riscv64");
        archSupported.add(BASE_ARCH_ARM);
        archSupported.add(ARCH_ARM64);
        archSupported.add("x86");
        archSupported.add("x86_64");
        archSupported.add("mips");
        archSupported.add("mips64");
        archSupported.add("riscv64");
    }
}

