/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.controller.test;

import com.google.auto.value.AutoValue;
import com.google.devtools.mobileharness.infra.controller.test.AutoValue_TestContext;
import com.google.wireless.qa.mobileharness.shared.model.job.JobLocator;
import com.google.wireless.qa.mobileharness.shared.model.job.TestLocator;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

@AutoValue
public abstract class TestContext {
    public static final TestContext EMPTY = TestContext.createEmpty();
    private static final ThreadLocal<TestContext> LOCAL_TEST_CONTEXT = new ThreadLocal<TestContext>(){

        @Override
        protected TestContext initialValue() {
            return EMPTY;
        }
    };

    public static synchronized TestContext get() {
        return LOCAL_TEST_CONTEXT.get();
    }

    public static synchronized WithTestContext set(TestContext testContext) {
        LOCAL_TEST_CONTEXT.set(testContext);
        return new WithTestContext();
    }

    public static synchronized WithTestContext set(TestLocator testLocator) {
        return TestContext.set(TestContext.create(testLocator));
    }

    public static synchronized void clear() {
        LOCAL_TEST_CONTEXT.remove();
    }

    private static TestContext create(TestLocator testLocator) {
        JobLocator jobLocator = testLocator.getJobLocator();
        return new AutoValue_TestContext(testLocator, jobLocator);
    }

    private static TestContext createEmpty() {
        return new AutoValue_TestContext(null, null);
    }

    @Nullable
    public abstract TestLocator testLocator();

    @Nullable
    public abstract JobLocator jobLocator();

    public static class WithTestContext
    implements AutoCloseable {
        @Override
        public void close() {
            TestContext.clear();
        }
    }

    public static class TestContextCallable<T>
    implements Callable<T> {
        private final TestContext creatorContext = TestContext.get();
        private final Callable<T> callable;

        public TestContextCallable(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public final T call() throws Exception {
            try (WithTestContext context = TestContext.set(this.creatorContext);){
                T t2 = this.callable.call();
                return t2;
            }
        }
    }

    public static class TestContextRunnable
    implements Runnable {
        private final TestContext creatorContext = TestContext.get();
        private final Runnable runnable;

        public TestContextRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public final void run() {
            try (WithTestContext context = TestContext.set(this.creatorContext);){
                this.runnable.run();
            }
        }
    }
}

