/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.util.subplan;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.platform.android.xts.common.util.XtsDirUtil;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import java.nio.file.Path;
import javax.inject.Inject;

public class SubPlanLister {
    private final LocalFileUtil localFileUtil;

    @Inject
    SubPlanLister(LocalFileUtil localFileUtil) {
        this.localFileUtil = localFileUtil;
    }

    public ImmutableList<String> listSubPlans(String xtsRootDir, String xtsType) throws MobileHarnessException {
        Path subPlansDir = XtsDirUtil.getXtsSubPlansDir(Path.of(xtsRootDir, new String[0]), xtsType);
        if (!subPlansDir.toFile().exists()) {
            throw new IllegalStateException(String.format("Subplans directory %s does not exist.", subPlansDir.toAbsolutePath()));
        }
        return this.localFileUtil.listFilePaths(subPlansDir, false, path -> path.getFileName().toString().endsWith(".xml")).stream().map(path -> Files.getNameWithoutExtension(path.getFileName().toString())).sorted().collect(ImmutableList.toImmutableList());
    }
}

