/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.util.plan;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.infra.ats.common.plan.PlanConfigUtil;
import com.google.devtools.mobileharness.infra.ats.console.ConsoleInfo;
import com.google.devtools.mobileharness.infra.ats.console.util.command.CommandHelper;
import com.google.devtools.mobileharness.platform.android.xts.common.util.XtsDirUtil;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;

public class PlanHelper {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final PlanConfigUtil planConfigUtil;
    private final ConsoleInfo consoleInfo;
    private final CommandHelper commandHelper;
    private final Supplier<ImmutableMap<String, PlanConfigUtil.PlanConfigInfo>> plansSupplier = Suppliers.memoize(this::doListPlans);

    @Inject
    PlanHelper(PlanConfigUtil planConfigUtil, ConsoleInfo consoleInfo, CommandHelper commandHelper) {
        this.planConfigUtil = planConfigUtil;
        this.consoleInfo = consoleInfo;
        this.commandHelper = commandHelper;
    }

    public ImmutableMap<String, PlanConfigUtil.PlanConfigInfo> listPlans() {
        return this.plansSupplier.get();
    }

    public String loadConfigContent(String configName) {
        ImmutableMap<String, PlanConfigUtil.PlanConfigInfo> configInfo = this.listPlans();
        if (!configInfo.containsKey(configName)) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Config [%s] not found.", configName);
            return "";
        }
        PlanConfigUtil.PlanConfigInfo planConfigInfo = configInfo.get(configName);
        Optional<InputStream> content = this.planConfigUtil.getBundledConfigStream(planConfigInfo.source(), configName);
        if (content.isEmpty()) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to load config [%s] content.", configName);
            return "";
        }
        return this.convertPlanStreamToString(content.get());
    }

    private String convertPlanStreamToString(InputStream inputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).withCause(e)).log("Failed to convert config content to string");
            return "";
        }
        return stringBuilder.toString();
    }

    private ImmutableMap<String, PlanConfigUtil.PlanConfigInfo> doListPlans() {
        Path xtsRootDir = this.consoleInfo.getXtsRootDirectoryNonEmpty();
        Path toolsDir = XtsDirUtil.getXtsToolsDir(xtsRootDir, this.commandHelper.getXtsType());
        return this.planConfigUtil.loadAllConfigsInfo(toolsDir);
    }
}

