/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.controller.sessionplugin;

import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.infra.ats.console.controller.proto.SessionPluginProto;
import com.google.devtools.mobileharness.infra.ats.console.controller.sessionplugin.AtsSessionPluginConfigOutput;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import com.google.devtools.mobileharness.shared.util.base.TableFormatter;
import com.google.devtools.mobileharness.shared.util.comparator.NaturalSortOrderComparator;
import com.google.devtools.mobileharness.shared.util.time.TimeUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PluginOutputPrinter {
    private static final ImmutableList<String> LIST_INVOCATIONS_HEADER = ImmutableList.of("Command Id", "Exec Time", "Device", "State");

    @CanIgnoreReturnValue
    public static int printOutput(SessionPluginProto.AtsSessionPluginOutput output, ConsoleUtil consoleUtil) {
        switch (output.getResultCase()) {
            case SUCCESS: {
                consoleUtil.printlnStdout(output.getSuccess().getOutputMessage());
                return 0;
            }
            case FAILURE: {
                consoleUtil.printlnStderr("Error: %s", output.getFailure().getErrorMessage());
                break;
            }
        }
        return 1;
    }

    public static String listCommands(List<AtsSessionPluginConfigOutput> configOutputs) {
        return configOutputs.stream().map(PluginOutputPrinter::getRunCommandState).sorted(Comparator.comparing(SessionPluginProto.RunCommandState::getCommandId, new NaturalSortOrderComparator())).map(PluginOutputPrinter::formatCommand).collect(Collectors.joining("\n"));
    }

    public static int showCommandInvocations(List<AtsSessionPluginConfigOutput> configOutputs, String commandId, ConsoleUtil consoleUtil) {
        String invocations = configOutputs.stream().map(PluginOutputPrinter::getRunCommandState).filter(runCommandState -> runCommandState.getCommandId().equals(commandId)).map(PluginOutputPrinter::formatInvocationCommand).collect(Collectors.joining("\n"));
        if (invocations.isEmpty()) {
            consoleUtil.printlnStdout(String.format("No information found for invocation %s.", commandId));
            return 2;
        }
        consoleUtil.printlnStdout(invocations);
        return 0;
    }

    public static String listInvocations(List<AtsSessionPluginConfigOutput> configOutputs) {
        ImmutableList invocations = configOutputs.stream().map(PluginOutputPrinter::getRunCommandState).flatMap(runCommandState -> runCommandState.getRunningInvocationMap().values().stream()).flatMap(testInvocations -> testInvocations.getInvocationList().stream()).sorted(Comparator.comparing(SessionPluginProto.RunCommandState.Invocation::getCommandId, new NaturalSortOrderComparator()).thenComparing(invocation -> TimeUtils.toJavaInstant(invocation.getStartTime()))).map(PluginOutputPrinter::formatInvocation).collect(ImmutableList.toImmutableList());
        if (invocations.isEmpty()) {
            return "";
        }
        ImmutableList table = Stream.concat(Stream.of(LIST_INVOCATIONS_HEADER), invocations.stream()).collect(ImmutableList.toImmutableList());
        return TableFormatter.displayTable(table);
    }

    private static SessionPluginProto.RunCommandState getRunCommandState(AtsSessionPluginConfigOutput pluginConfigOutput) {
        return pluginConfigOutput.output().flatMap(pluginOutput -> pluginOutput.hasRunCommandState() ? Optional.of(pluginOutput.getRunCommandState()) : Optional.empty()).orElse(pluginConfigOutput.config().getRunCommand().getInitialState());
    }

    private static String formatCommand(SessionPluginProto.RunCommandState runCommandState) {
        return String.format("Command %s: [%s] %s", runCommandState.getCommandId().isEmpty() ? "n/a" : runCommandState.getCommandId(), PluginOutputPrinter.getTimeString(TimeUtils.toJavaDuration(runCommandState.getTotalExecutionTime())), runCommandState.getCommandLineArgs());
    }

    private static String formatInvocationCommand(SessionPluginProto.RunCommandState runCommandState) {
        return runCommandState.getRunningInvocationMap().values().stream().flatMap(testInvocations -> testInvocations.getInvocationList().stream()).sorted(Comparator.comparing(SessionPluginProto.RunCommandState.Invocation::getCommandId, new NaturalSortOrderComparator()).thenComparing(invocation -> TimeUtils.toJavaInstant(invocation.getStartTime()))).map(invocation -> String.format("invocation %s: [%s]", invocation.getCommandId(), String.join((CharSequence)", ", runCommandState.getSeparatedCommandLineArgsList()))).collect(Collectors.joining("\n"));
    }

    private static String getTimeString(Duration duration) {
        long hours = duration.toHours();
        long minutes = duration.toMinutesPart();
        long seconds = duration.toSecondsPart();
        if (hours > 0L) {
            return String.format("%dh:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%dm:%02d", minutes, seconds);
    }

    private static ImmutableList<String> formatInvocation(SessionPluginProto.RunCommandState.Invocation invocation) {
        return ImmutableList.of(invocation.getCommandId(), TimeUtils.toReadableDurationString(Duration.between(TimeUtils.toJavaInstant(invocation.getStartTime()), Instant.now())), invocation.getDeviceIdList().stream().collect(Collectors.joining(", ", "[", "]")), invocation.getStateSummary());
    }

    private PluginOutputPrinter() {
    }
}

