/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command.alias;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.console.ConsoleInfo;
import com.google.devtools.mobileharness.infra.ats.console.util.command.CommandHelper;
import com.google.devtools.mobileharness.platform.android.xts.common.util.XtsDirUtil;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AliasManager {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String ALIASES_FILE_NAME = "aliases";
    private static final Pattern ALIAS_DEFINITION_PATTERN = Pattern.compile("alias (.+?)=['\"]?(.*?)['\"]?$");
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final ConsoleInfo consoleInfo;
    private final CommandHelper commandHelper;
    private final LocalFileUtil localFileUtil;
    private boolean predefinedAliasesLoaded = false;

    @Inject
    AliasManager(ConsoleInfo consoleInfo, CommandHelper commandHelper, LocalFileUtil localFileUtil) {
        this.consoleInfo = consoleInfo;
        this.commandHelper = commandHelper;
        this.localFileUtil = localFileUtil;
    }

    public void addAlias(String name, String value) {
        this.aliases.put(name, value);
    }

    public Optional<String> getAlias(String name) {
        this.ensurePredefinedAliasesLoaded();
        return Optional.ofNullable(this.aliases.get(name));
    }

    public ImmutableMap<String, String> getAll() {
        this.ensurePredefinedAliasesLoaded();
        return ImmutableMap.copyOf(this.aliases);
    }

    private void ensurePredefinedAliasesLoaded() {
        String aliases;
        if (this.predefinedAliasesLoaded) {
            return;
        }
        this.predefinedAliasesLoaded = true;
        Path xtsToolsDir = XtsDirUtil.getXtsToolsDir(this.consoleInfo.getXtsRootDirectoryNonEmpty(), this.commandHelper.getXtsType());
        Path aliasesFilePath = xtsToolsDir.resolve(ALIASES_FILE_NAME);
        if (!this.localFileUtil.isFileExist(aliasesFilePath)) {
            return;
        }
        try {
            aliases = this.localFileUtil.readFile(aliasesFilePath);
        }
        catch (MobileHarnessException e) {
            ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).withCause(e)).log("Failed to read aliases file: %s", aliasesFilePath);
            return;
        }
        Splitter.on('\n').splitToStream(aliases).forEach(alias -> {
            Matcher matcher = ALIAS_DEFINITION_PATTERN.matcher((CharSequence)alias);
            if (matcher.matches()) {
                String aliasName = matcher.group(1).trim();
                String aliasValue = matcher.group(2).trim();
                this.addAlias(aliasName, aliasValue);
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Alias '%s' loaded, value: [%s].", (Object)aliasName, (Object)aliasValue);
            } else {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Invalid alias definition [%s] ignored.", alias);
            }
        });
    }
}

