/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command;

import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerPreparer;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import picocli.CommandLine;

@CommandLine.Command(name="server", sortOptions=false, description={"Restart the OLC server, etc"}, synopsisSubcommandLabel="")
final class ServerCommand
implements Callable<Integer> {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    private final ConsoleUtil consoleUtil;
    private final ServerPreparer serverPreparer;

    @Inject
    ServerCommand(ConsoleUtil consoleUtil, ServerPreparer serverPreparer) {
        this.consoleUtil = consoleUtil;
        this.serverPreparer = serverPreparer;
    }

    @Override
    public Integer call() {
        throw new CommandLine.ParameterException(this.spec.commandLine(), "Missing required subcommand");
    }

    @CommandLine.Command(name="restart", aliases={"r"}, description={"Restart the OLC server. Use --forcibly or -f to forcibly kill the existing server."})
    public void restart(@CommandLine.Option(names={"--forcibly", "-f"}) boolean forcibly) throws MobileHarnessException, InterruptedException {
        if (this.serverPreparer.tryConnectToOlcServer().isPresent()) {
            this.serverPreparer.killExistingServer(forcibly);
        } else {
            this.consoleUtil.printlnStdout("No running OLC server found.");
        }
        this.serverPreparer.prepareOlcServer();
    }
}

