/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command;

import com.google.common.base.Ascii;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerPreparer;
import com.google.devtools.mobileharness.infra.ats.console.constant.AtsConsoleDirs;
import com.google.devtools.mobileharness.infra.ats.console.controller.olcserver.AtsSessionStub;
import com.google.devtools.mobileharness.infra.ats.console.controller.proto.SessionPluginProto;
import com.google.devtools.mobileharness.infra.ats.console.controller.sessionplugin.PluginOutputPrinter;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import com.google.devtools.mobileharness.infra.ats.console.util.log.LogDumper;
import com.google.devtools.mobileharness.infra.ats.console.util.plan.PlanHelper;
import com.google.devtools.mobileharness.infra.client.longrunningservice.constant.OlcServerDirs;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.VersionServiceProto;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.base.ProtoTextFormat;
import com.google.devtools.mobileharness.shared.util.command.Command;
import com.google.devtools.mobileharness.shared.util.command.CommandException;
import com.google.devtools.mobileharness.shared.util.command.CommandExecutor;
import com.google.devtools.mobileharness.shared.util.error.MoreThrowables;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import com.google.devtools.mobileharness.shared.util.path.PathUtil;
import com.google.wireless.qa.mobileharness.shared.constant.DirCommon;
import java.nio.file.attribute.FileAttribute;
import java.time.InstantSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import picocli.CommandLine;

@CommandLine.Command(name="dump", aliases={"d"}, sortOptions=false, description={"Dump logs, bugreport, config, etc."}, synopsisSubcommandLabel="", subcommands={CommandLine.HelpCommand.class})
class DumpCommand
implements Callable<Integer> {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String TRADEFED_CLASS_NAME = "CompatibilityConsole";
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    private static final String DUMP_STACK_TRACE_SESSION_NAME = "dump_stack_trace_command";
    private static final SessionPluginProto.DumpCommand DUMP_STACK_TRACE_COMMAND = SessionPluginProto.DumpCommand.newBuilder().setDumpStackTraceCommand(SessionPluginProto.DumpStackTraceCommand.getDefaultInstance()).build();
    private final ConsoleUtil consoleUtil;
    private final ServerPreparer serverPreparer;
    private final AtsSessionStub atsSessionStub;
    private final LocalFileUtil localFileUtil;
    private final PlanHelper planHelper;
    private final CommandExecutor cmdExecutor;
    private final InstantSource instantSource;

    @Inject
    DumpCommand(ConsoleUtil consoleUtil, ServerPreparer serverPreparer, AtsSessionStub atsSessionStub, LocalFileUtil localFileUtil, PlanHelper planHelper, CommandExecutor cmdExecutor, InstantSource instantSource) {
        this.consoleUtil = consoleUtil;
        this.serverPreparer = serverPreparer;
        this.atsSessionStub = atsSessionStub;
        this.localFileUtil = localFileUtil;
        this.planHelper = planHelper;
        this.cmdExecutor = cmdExecutor;
        this.instantSource = instantSource;
    }

    @Override
    public Integer call() {
        throw new CommandLine.ParameterException(this.spec.commandLine(), "Missing required subcommand");
    }

    @CommandLine.Command(name="bugreport", aliases={"b"}, description={"Dump a bugreport for the running instance"})
    public int bugreport() throws MobileHarnessException, InterruptedException {
        this.printLogDirs();
        String baseDirPath = PathUtil.join(DirCommon.getTempDirRoot(), "ats_bugreport");
        String fileSuffix = Long.toString(this.instantSource.instant().toEpochMilli());
        String bugreportName = "ats_bugreport_" + fileSuffix;
        String bugreportDirPath = PathUtil.join(baseDirPath, bugreportName);
        this.consoleUtil.printlnStdout("Bugreport dir: %s", bugreportDirPath);
        this.localFileUtil.prepareDir(bugreportDirPath, new FileAttribute[0]);
        this.localFileUtil.copyFileOrDir(AtsConsoleDirs.getLogDir(), PathUtil.join(bugreportDirPath, String.format("ats_console_logs_%s", fileSuffix)));
        this.localFileUtil.copyFileOrDir(OlcServerDirs.getLogDir(), PathUtil.join(bugreportDirPath, String.format("olc_server_logs_%s", fileSuffix)));
        this.localFileUtil.writeToFile(PathUtil.join(bugreportDirPath, String.format("ats_console_stack_trace_%s.txt", fileSuffix)), MoreThrowables.formatStackTraces());
        String serverStackTraceFilePath = PathUtil.join(bugreportDirPath, String.format("olc_server_stack_trace_%s.txt", fileSuffix));
        this.createServerStackTraceFile(serverStackTraceFilePath);
        List<String> tradefedPids = this.getTradefedPids();
        if (tradefedPids.isEmpty()) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("No Tradefed process found. Skip dumping Tradefed stack trace.");
        } else {
            tradefedPids.forEach(tradefedPid -> {
                String tradefedStackTraceFilePath = PathUtil.join(bugreportDirPath, String.format("tradefed_stack_trace_%s_pid_%s.txt", fileSuffix, tradefedPid));
                this.createTradefedStackTraceFile(tradefedStackTraceFilePath, (String)tradefedPid);
            });
        }
        String bugreportFilePath = PathUtil.join(baseDirPath, String.format("%s.zip", bugreportName));
        this.localFileUtil.zipDir(bugreportDirPath, bugreportFilePath);
        this.consoleUtil.printlnStdout("Output bugreport zip in %s", bugreportFilePath);
        return 0;
    }

    @CommandLine.Command(name="config", aliases={"c"}, description={"Dump the content of the specified config"})
    public int config(@CommandLine.Parameters(index="0", paramLabel="<config>", hideParamSyntax=true, description={"Name of the config to dump."}) String configName) {
        String config = this.planHelper.loadConfigContent(configName);
        this.consoleUtil.printlnStdout(config);
        return 0;
    }

    @CommandLine.Command(name="env", aliases={"e"}, description={"Dump the environment variables available to test harness process"})
    public int env() throws MobileHarnessException, InterruptedException {
        return this.runDumpCommandSessionAndPrint("dump_env_var_command", SessionPluginProto.DumpCommand.newBuilder().setDumpEnvVarCommand(SessionPluginProto.DumpEnvVarCommand.getDefaultInstance()).build());
    }

    @CommandLine.Command(name="logs", aliases={"l"}, description={"Dump the logs of all invocations to files"})
    public int logs() {
        this.printLogDirs();
        return 0;
    }

    @CommandLine.Command(name="stack", aliases={"s"}, description={"Dump the stack traces of a Java process"})
    public int stack(@CommandLine.Parameters(index="0", paramLabel="<process>", defaultValue="OLC", description={"Process to dump stack traces for: [${COMPLETION-CANDIDATES}]. Default value: ${DEFAULT-VALUE}."}, completionCandidates=ProcessCandidatesToDumpStackTrace.class) String processType) throws MobileHarnessException, InterruptedException {
        return switch (Ascii.toLowerCase(processType)) {
            case "olc" -> this.runDumpCommandSessionAndPrint(DUMP_STACK_TRACE_SESSION_NAME, DUMP_STACK_TRACE_COMMAND);
            case "tradefed" -> this.dumpTradefedStackTrace();
            default -> throw new CommandLine.ParameterException(this.spec.commandLine(), "Unsupported process type: " + processType);
        };
    }

    @CommandLine.Command(name="uptime", aliases={"u"}, description={"Dump how long the process has been running"})
    public int uptime() throws MobileHarnessException, InterruptedException {
        return this.runDumpCommandSessionAndPrint("dump_uptime_command", SessionPluginProto.DumpCommand.newBuilder().setDumpUptimeCommand(SessionPluginProto.DumpUptimeCommand.getDefaultInstance()).build());
    }

    private void printLogDirs() {
        this.consoleUtil.printlnStdout(LogDumper.dumpLog(LogDumper.LogDirsType.ALL));
    }

    private void createServerStackTraceFile(String filePath) {
        block7: {
            try {
                String serverStackTrace;
                Optional<VersionServiceProto.GetVersionResponse> tryConnectResult = this.serverPreparer.tryConnectToOlcServer();
                if (tryConnectResult.isEmpty()) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("OLC server isn't running, skip dumping server stack trace");
                    return;
                }
                SessionPluginProto.AtsSessionPluginOutput output = this.runDumpCommandSession(DUMP_STACK_TRACE_SESSION_NAME, DUMP_STACK_TRACE_COMMAND);
                switch (output.getResultCase()) {
                    case SUCCESS: {
                        serverStackTrace = output.getSuccess().getOutputMessage();
                        break;
                    }
                    case FAILURE: {
                        ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to get server stack trace, reason: %s", output.getFailure().getErrorMessage());
                        return;
                    }
                    default: {
                        ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to get server stack trace, plugin_output=[%s]", ProtoTextFormat.shortDebugString(output));
                        return;
                    }
                }
                this.localFileUtil.writeToFile(filePath, serverStackTrace);
            }
            catch (MobileHarnessException | Error | InterruptedException | RuntimeException e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to create server stack trace file, error=[%s]", MoreThrowables.shortDebugString(e));
                if (!(e instanceof InterruptedException)) break block7;
                Thread.currentThread().interrupt();
            }
        }
    }

    private void createTradefedStackTraceFile(String filePath, String tradefedPid) {
        block2: {
            try {
                String tradefedStackTrace = this.getTradefedStackTrace(tradefedPid);
                this.localFileUtil.writeToFile(filePath, tradefedStackTrace);
            }
            catch (MobileHarnessException | Error | InterruptedException | RuntimeException e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to create Tradefed stack trace file for pid [%s]: %s.", (Object)tradefedPid, (Object)MoreThrowables.shortDebugString(e));
                if (!(e instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
    }

    private int runDumpCommandSessionAndPrint(String sessionName, SessionPluginProto.DumpCommand dumpCommand) throws MobileHarnessException, InterruptedException {
        SessionPluginProto.AtsSessionPluginOutput output = this.runDumpCommandSession(sessionName, dumpCommand);
        return PluginOutputPrinter.printOutput(output, this.consoleUtil);
    }

    private SessionPluginProto.AtsSessionPluginOutput runDumpCommandSession(String sessionName, SessionPluginProto.DumpCommand dumpCommand) throws MobileHarnessException, InterruptedException {
        this.serverPreparer.prepareOlcServer();
        return this.atsSessionStub.runShortSession(sessionName, SessionPluginProto.AtsSessionPluginConfig.newBuilder().setDumpCommand(dumpCommand).build());
    }

    private int dumpTradefedStackTrace() {
        try {
            List<String> tradefedPids = this.getTradefedPids();
            if (tradefedPids.isEmpty()) {
                this.consoleUtil.printlnStdout("No Tradefed process found.");
                return 1;
            }
            for (String tradefedPid : tradefedPids) {
                String tradefedStackTrace = this.getTradefedStackTrace(tradefedPid);
                this.consoleUtil.printlnStdout("Tradefed stack trace for pid [%s]:", tradefedPid);
                this.consoleUtil.printlnStdout(tradefedStackTrace);
            }
            return 0;
        }
        catch (CommandException | Error | InterruptedException | RuntimeException e) {
            this.consoleUtil.printlnStdout("Failed to dump Tradefed stack trace: " + e.getMessage());
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return 1;
        }
    }

    private List<String> getTradefedPids() throws CommandException, InterruptedException {
        String output = this.cmdExecutor.run(Command.of("/bin/sh", "-c", String.format("jps | grep %s | awk '{print $1}'", TRADEFED_CLASS_NAME)));
        return output.isEmpty() ? ImmutableList.of() : Splitter.on('\n').omitEmptyStrings().splitToList(output);
    }

    private String getTradefedStackTrace(String tradefedPid) throws CommandException, InterruptedException {
        return this.cmdExecutor.run(Command.of("/bin/sh", "-c", String.format("jstack %s", tradefedPid)));
    }

    private static class ProcessCandidatesToDumpStackTrace
    extends ArrayList<String> {
        ProcessCandidatesToDumpStackTrace() {
            super(ImmutableList.of("OLC", "Tradefed"));
        }
    }
}

